﻿<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="System.Diagnostics" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.ComponentModel" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Place" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Kalend" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Business.Db" %>
<%@ Import Namespace="Soneta.Business.UI" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="System.Linq" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Deklaracja ERP-7</title>
    <script runat="server">
public enum WgParametr {
            WgDatyWypłaty,
            WgOkresuListyPłac,
            [Caption("Wg miesiąca ZUS")]
            WgMiesiącaZUS,
            WgOkresuElementu
        }

        //Odchyłki na plus dla elementów o stałej wartości wykazuj jako elementy o zminnej wartości    
        static bool odchyłkiPlusJakoZmienne = false;

        public class Params : ContextBase {

            public Params(Context context) : base(context) {
                okres = FromTo.All;
            }

            public enum PodstawaPrzychodEnum
            {
                [Caption("Przychód")]
                Przychod,

                [Caption("Podstawa EiR")]
                Podstawa
            }

            PodstawaPrzychodEnum wykazywany = PodstawaPrzychodEnum.Przychod;
            [Priority(1)]
            [Caption("W kol. 2 i 7 wykazuj")]
            public PodstawaPrzychodEnum Kol2i7
            {
                get { return wykazywany; }
                set { wykazywany = value; OnChanged(EventArgs.Empty); }
            }

            FromTo okres;
            [Required]
            [Caption("Raport za okres:")]
            public FromTo Okres {
                get { return okres; }
                set {
                    okres = value;
                    OnChanged(EventArgs.Empty);
                }
            }
        }

        Params pars;
        [Context]
        public Params Pars {
            get { return pars; }
            set { pars = value; }
        }

        public class SrParams : SerializableContextBase {
            public SrParams(Context context) : base(context) {
            }
            bool sumyBezLimitu = false;
            [Priority(2)]
            [Caption("Sumy bez lim.podst.E/R")]
            [Browsable(false)]
            public bool SumyBezLimitu {
                get { return sumyBezLimitu; }
                set {
                    sumyBezLimitu = value;
                    if (sumyBezLimitu)
                        uwzględnijSwiadczenia = false;
                    OnChanged(EventArgs.Empty);
                }
            }

            bool uwzględnijSwiadczenia = true;
            [Priority(3)]
            [Caption("Uwzględnij świadczenia")]
            [Browsable(false)]
            public bool UwzględnijSwiadczenia {
                get { return uwzględnijSwiadczenia; }
                set {
                    uwzględnijSwiadczenia = value;
                    OnChanged(EventArgs.Empty);
                }
            }

            public bool IsReadOnlyUwzględnijSwiadczenia() {
                return sumyBezLimitu;
            }

            bool pokażLimit = false;
            [Priority(4)]
            [Caption("Pokaż limit")]
            [Browsable(false)]
            public bool PokażLimit {
                get { return pokażLimit; }
                set {
                    pokażLimit = value;
                    OnChanged(EventArgs.Empty);
                }
            }

            bool uzupełnijRodzaj = true;
            [Priority(5)]
            [Caption("Uzupełnij rodzaj")]
            [Browsable(false)]
            public bool UzupełnijRodzaj {
                get { return uzupełnijRodzaj; }
                set {
                    uzupełnijRodzaj = value;
                    OnChanged(EventArgs.Empty);
                }
            }

            WgParametr wgParam = WgParametr.WgOkresuElementu;
            [Priority(6)]
            [Caption("Wynagrodzenie")]
            public WgParametr WgParam {
                get { return wgParam; }
                set {
                    wgParam = value;
                    OnChanged(EventArgs.Empty);
                }
            }
        }

        SrParams srpars;
        [SettingsContext]
        public SrParams SrPars {
            get { return srpars; }
            set { srpars = value; }
        }

        interface ITotal {
            int Rok { get; }
            decimal StałeZmienne { get; }
            int MiesiacPrzekroczeniaZUS { get; }
            string ZmienneOpis { get; }
            decimal ChoroboweZasiłki { get; }
            decimal UrlopyRehab { get; }
            decimal Inne { get; }
            string InneOpis { get; }
            decimal SkładkiBezZus { get; }
            decimal PonadLimit { get; }
            decimal Razem { get; }

        }

        class Total2 : ITotal {
            int rok;
            public int Rok { get { return rok; } }
            decimal stałeZmienne;
            public decimal StałeZmienne { get { return stałeZmienne; } }
            string zmienneOpis;
            public string ZmienneOpis { get { return zmienneOpis; } }
            decimal choroboweZasiłki;
            public decimal ChoroboweZasiłki { get { return choroboweZasiłki; } }
            decimal urlopyRehab;
            public decimal UrlopyRehab { get { return urlopyRehab; } }
            decimal inne;
            public decimal Inne { get { return inne; } }
            string inneOpis;
            public string InneOpis { get { return inneOpis; } }
            decimal składkiBezZus;
            public decimal SkładkiBezZus { get { return składkiBezZus; } }
            decimal ponadLimit;
            public decimal PonadLimit { get { return ponadLimit; } }
            decimal razem;
            public decimal Razem { get { return razem; } }
            int miesiacPrzekroczeniaZUS;
            public int MiesiacPrzekroczeniaZUS { get { return miesiacPrzekroczeniaZUS; } }
        

            public Total2(WynagrodzenieERP7 wynagrodzenieERP7) {
                rok = wynagrodzenieERP7.Rok;
                miesiacPrzekroczeniaZUS = wynagrodzenieERP7.MiesiacPrzekroczeniaZUS;
                stałeZmienne = wynagrodzenieERP7.KwotyStaleZmienne;
                choroboweZasiłki = wynagrodzenieERP7.KwotySwiadczeniaKol3;
                urlopyRehab = wynagrodzenieERP7.KwotySwiadczeniaKol4;
                składkiBezZus = wynagrodzenieERP7.KwotyNieoskladkowane;
                ponadLimit = wynagrodzenieERP7.KwotyWypadkowego;
                inne = wynagrodzenieERP7.KwotyInne;
                inneOpis = wynagrodzenieERP7.RodzajInne;               
            }
        }

        class Total : ITotal {
            decimal[] sumyDoLimitu = new decimal[6];
            decimal[] sumyPonadLimit = new decimal[6];
            Hashtable[] definicje = new Hashtable[6];
            readonly int rok;
            readonly SrParams srpars;
            readonly Params pars;
            public YearMonth przekroczenie = YearMonth.MaxValue;
            public Total(int rok, SrParams srpars, Params pars) {
                this.rok = rok;
                this.srpars = srpars;
                this.pars = pars;
                for (int i = 0; i < 6; i++)
                    definicje[i] = new Hashtable();
            }

            public void Add(WypElement element) {
                PozycjaRP7 pozycja = element.Definicja.Deklaracje.PozycjaRP7;
                if (pozycja != PozycjaRP7.NieDotyczy) {
                    if (element is WypElementUmowa && element.Podatki.Wypadkowa.Firma == 0)
                        return;

                    decimal kwotaDoRaportu =
                        (pars.Kol2i7 == Params.PodstawaPrzychodEnum.Podstawa
                         && (pozycja == PozycjaRP7.SkładnikiStałe
                             || pozycja == PozycjaRP7.SkładnikiZmienne
                             || pozycja == PozycjaRP7.Inne))
                            ? element.Podatki.Emerytalna.Podstawa
                            : element.Wartosc;     

                    decimal do_limitu;
                    decimal ponad_limit;

                    if (pozycja == PozycjaRP7.ŚwiadczeniaZUbezpieczenia)
                        ponad_limit = 0;
                    else
                        ponad_limit = element.Podatki.Wypadkowa.Podstawa - element.Podatki.Emerytalna.Podstawa;
                    if (ponad_limit != 0 && przekroczenie > element.MiesiacDeklaracji)
                        przekroczenie = element.MiesiacDeklaracji;

                    do_limitu = kwotaDoRaportu - ponad_limit;

                    decimal odchyłkiPlus = 0;
                    if (pozycja == PozycjaRP7.SkładnikiStałe && odchyłkiPlusJakoZmienne)
                        foreach (WypSkladnik skl in element.Skladniki)
                            if (skl.Rodzaj == RodzajSkładnikaWypłaty.OdchyłkaPlus)
                                odchyłkiPlus += skl.Wartosc;
                    decimal wartość = kwotaDoRaportu - odchyłkiPlus;

                    Zapisz(element, pozycja, wartość, ref do_limitu, ref ponad_limit);
                    Zapisz(element, PozycjaRP7.SkładnikiZmienne, odchyłkiPlus, ref do_limitu, ref ponad_limit);

                    WypElementNieobecność en = element as WypElementNieobecność;
                    Nieobecnosc ni = en == null ? null : en.Nieobecność;
                    if (ni != null && ni.Definicja.Przyczyna == PrzyczynaNieobecnosci.UrlopRehabilitacyjny)
                        urlopyRehab += wartość;
                    else {
                        KodRSA kod = element.KodRSA;
                        if (element.ZasiłekZus || (kod != null && kod.WynagrodzenieChorobowe))
                            choroboweZasiłki += wartość;
                    }
                }
            }
            void Zapisz(WypElement element, PozycjaRP7 pozycja, decimal wartość, ref decimal do_limitu, ref decimal ponad_limit) {
                int n = (int)pozycja - 1;

                if (pozycja == PozycjaRP7.ŚwiadczeniaWNaturze) {
                    n = 5;
                }

                bool rodzaj = wartość != 0;
                if (wartość <= do_limitu) {
                    sumyDoLimitu[n] += wartość;
                    do_limitu -= wartość;
                    wartość = 0;
                }
                else {
                    sumyDoLimitu[n] += do_limitu;
                    wartość -= do_limitu;
                    do_limitu = 0;
                }
                if (wartość <= ponad_limit) {
                    sumyPonadLimit[n] += wartość;
                    ponad_limit -= wartość;
                    wartość = 0;
                }
                else {
                    sumyPonadLimit[n] += ponad_limit;
                    wartość -= ponad_limit;
                    ponad_limit = 0;
                }
                if (definicje[n][element.Definicja] == null && rodzaj)
                    definicje[n].Add(element.Definicja, element.Definicja.Skrot);
            }
            public int Rok {
                get {
                    return rok;
                }
            }

            public int MiesiacPrzekroczeniaZUS { get { return 0; } }

            public decimal StałeZmienne { get { return Stałe + Zmienne; } }

            public decimal Stałe {
                get { return Dodaj(sumyDoLimitu[0], sumyPonadLimit[0], srpars.SumyBezLimitu); }
            }
            public decimal Zmienne {
                get { return Dodaj(sumyDoLimitu[1], sumyPonadLimit[1], srpars.SumyBezLimitu); }
            }
            public string ZmienneOpis {
                get { return ToStr(definicje[1].Values); }
            }
            private decimal choroboweZasiłki;
            public decimal ChoroboweZasiłki {
                get { return choroboweZasiłki; }
            }
            private decimal urlopyRehab;
            public decimal UrlopyRehab {
                get { return urlopyRehab; }
            }
            private decimal wynagrodzInne;
            public decimal WynagrodzInne {
                get { return wynagrodzInne; }
            }
            public decimal Inne {
                get { return Dodaj(sumyDoLimitu[2], sumyPonadLimit[2], srpars.SumyBezLimitu); }
            }
            public string InneOpis {
                get { return ToStr(definicje[2].Values); }
            }
            public decimal WNaturze {
                get { return Dodaj(sumyDoLimitu[3], sumyPonadLimit[3], srpars.SumyBezLimitu); }
            }
            public string WNaturzeOpis {
                get { return ToStr(definicje[3].Values); }
            }
            public decimal Świadczenia {
                get { return Dodaj(sumyDoLimitu[4], sumyPonadLimit[4], srpars.SumyBezLimitu); }
            }
            public decimal SkładkiBezZus {
                get { return Dodaj(sumyDoLimitu[5], sumyPonadLimit[5], srpars.SumyBezLimitu); }
            }
            public decimal PonadLimit {
                get { return Suma(sumyPonadLimit); }
            }
            public decimal Razem {
                get {
                    decimal a = Suma(sumyDoLimitu) - sumyDoLimitu[4];
                    decimal b = Suma(sumyPonadLimit) - sumyPonadLimit[4];
                    if (srpars.UwzględnijSwiadczenia)
                        b += Świadczenia;
                    return Dodaj(a, b, !srpars.SumyBezLimitu);
                }
            }
            string ToStr(IEnumerable lista) {
                string ss = "";
                //Wg ZUS pola rodzaj się nie uzupełnia
                if (srpars.UzupełnijRodzaj) //TID: 8385, ale jednak czasem się wypełnia
                    foreach (string s in lista)
                        if (ss == "")
                            ss = s;
                        else
                            ss += ", " + s;
                return ss;
            }

            decimal Suma(decimal[] lista) {
                decimal v = 0;
                foreach (decimal d in lista)
                    v += d;
                return v;
            }
            decimal Dodaj(decimal a, decimal b, bool dodaj) {
                return dodaj ? a + b : a;
            }
        }

        public class NieobecInfo {

            readonly FromTo okres;
            readonly string nazwa;
            readonly string kategoria;

            public NieobecInfo(string nazwa, FromTo okres, string kategoria) {
                this.nazwa = nazwa;
                this.okres = okres;
                this.kategoria = kategoria;
            }

            public FromTo Okres { get { return okres; } }
            public string Nazwa { get { return nazwa; } }
            public string Kategoria { get { return kategoria; } }
        }

         public class NieobecInfoComparer : IComparer<NieobecInfo> {

            public int Compare(NieobecInfo x, NieobecInfo y) {
                int i = string.Compare(x.Kategoria, y.Kategoria);
                if (i == 0)
                    i = x.Okres.From.CompareTo(y.Okres.From);
                return i;
            }
        }

        string NBSP(string ss) {
            return ss == "" ? "&nbsp;" : ss;
        }

        void LiczDaneFirmy(PracHistoria ph) {
            CoreModule core = CoreModule.GetInstance(dc);
            string nip = core.Config.Firma.Pieczątka.NIP;
            string regon = core.Config.Firma.Pieczątka.REGON;
            string nazwask = core.Config.Firma.Pieczątka.NazwaSkrócona;
            string nazwisko = core.Config.Firma.DaneEwidencyjne.Nazwisko;
            string imie = core.Config.Firma.DaneEwidencyjne.Imię;
            string kodp = core.Config.Firma.AdresSiedziby.KodPocztowyS;
            string poczta = core.Config.Firma.AdresSiedziby.Poczta;
            string gmina = core.Config.Firma.AdresSiedziby.Gmina;
            string miejscowosc = core.Config.Firma.AdresSiedziby.Miejscowosc;
            string ulica = core.Config.Firma.AdresSiedziby.Ulica;
            string dom = core.Config.Firma.AdresSiedziby.NrDomu;
            string lokal = core.Config.Firma.AdresSiedziby.NrLokalu;
            string tel = core.Config.Firma.AdresSiedziby.Telefon;
            string symbol = core.Config.Firma.AdresSiedziby.KodKraju;
            string kodz = core.Config.Firma.AdresSiedziby.ZagranicznyKodPocztowy;
            string panstwo = core.Config.Firma.AdresSiedziby.Kraj;
            if (ph.Etat.Wydzial != null && ph.Etat.Wydzial.Oddzial != null) {
                OddzialFirmy of = ph.Etat.Wydzial.Oddzial;
                if (!string.IsNullOrEmpty(of.Deklaracje.NIP)) nip = of.Deklaracje.NIP;
                if (!string.IsNullOrEmpty(of.Deklaracje.REGON)) regon = of.Deklaracje.REGON;
                if (!string.IsNullOrEmpty(of.NazwaSkrocona)) nazwask = of.NazwaSkrocona;
                if (!string.IsNullOrEmpty(of.Adres.KodPocztowyS)) kodp = of.Adres.KodPocztowyS;
                if (!string.IsNullOrEmpty(of.Adres.Poczta)) poczta = of.Adres.Poczta;
                if (!string.IsNullOrEmpty(of.Adres.Gmina)) gmina = of.Adres.Gmina;
                if (!string.IsNullOrEmpty(of.Adres.Miejscowosc)) miejscowosc = of.Adres.Miejscowosc;
                if (!string.IsNullOrEmpty(of.Adres.Ulica)) ulica = of.Adres.Ulica;
                if (!string.IsNullOrEmpty(of.Adres.NrDomu)) dom = of.Adres.NrDomu;
                if (!string.IsNullOrEmpty(of.Adres.NrLokalu)) lokal = of.Adres.NrLokalu;
                if (!string.IsNullOrEmpty(of.Adres.Telefon)) tel = of.Adres.Telefon;
                if (!string.IsNullOrEmpty(of.Adres.KodKraju)) symbol = of.Adres.KodKraju;
                if (!string.IsNullOrEmpty(of.Adres.ZagranicznyKodPocztowy)) kodz = of.Adres.ZagranicznyKodPocztowy;
                if (!string.IsNullOrEmpty(of.Adres.Kraj)) panstwo = of.Adres.Kraj;
            }

            FirmaNIP.EditValue = NBSP(nip.Replace("-", ""));
            FirmaREGON.EditValue = NBSP("");
            FirmaPESEL.EditValue = NBSP("");
            FirmaRodzaj.EditValue = NBSP("");
            FirmaDokument.EditValue = NBSP("");
            if (!string.IsNullOrEmpty(nazwask))
                FirmaNazwa.EditValue = NBSP(nazwask.ToUpper());
            else
                FirmaNazwa.EditValue = NBSP(imie.ToUpper()) + NBSP(nazwisko.ToUpper());
            FirmaKodP.EditValue = NBSP(kodp);
            ///        POCZTA.EditValue = NBSP(poczta);
            ///        GMINA.EditValue = NBSP(gmina);
            FirmaMiejscowosc.EditValue = NBSP(miejscowosc.ToUpper());
            FirmaUlica.EditValue = NBSP(ulica.ToUpper());
            FirmaNrDomu.EditValue = NBSP(dom);
            FirmaNrLokalu.EditValue = NBSP(lokal);
            ///        TEL.EditValue = NBSP(tel);
            ///        SYMBOL.EditValue = NBSP(symbol);
            ///        KODZ.EditValue = NBSP(kodz);
            FirmaKraj.EditValue = NBSP(panstwo.ToUpper());
            ///        MAIL.EditValue = NBSP("");

            if (regon != "")
                FirmaREGON.EditValue = NBSP(regon);
            if (nip == "" || regon == "")
                if (core.Config.Firma.DaneEwidencyjne.OsobaFizyczna) {
                    string pesel = core.Config.Firma.DaneEwidencyjne.PESEL;
                    if (pesel == "") {
                        Wlasciciel wls = DeklaracjeModule.GetInstance(dc).Config.ZUS.Ogólne.DaneWłaściciela;
                        if (wls != null) {
                            pesel = NBSP(wls.Last.PESEL);
                            if (pesel == "") {
                                FirmaRodzaj.EditValue = NBSP(""); //wls.Last.Dokument.Rodzaj == KodRodzajuDokumentu.DowodOsobisty ? "1" : "2");
                                FirmaDokument.EditValue = NBSP(wls.Last.Dokument.SeriaNumer.ToUpper());
                            }
                        }
                    }
                    if (pesel != "")
                        FirmaPESEL.EditValue = NBSP(pesel);
                }
        }

        void LiczDanePracownika(PracHistoria ph) {
            PracImieNazwisko1.EditValue = PracImieNazwisko2.EditValue = ph.Imie.ToUpper() + " " + ph.Nazwisko.ToUpper();

            bool dowod = ph.Dokument.Rodzaj == KodRodzajuDokumentu.DowodOsobisty;
            if (ph.NIP == "" || ph.PESEL == "") {
                //DOKRODZAJ.EditValue = dowod ? "1" : "2";
                DOKUBEZP.EditValue = ph.Dokument.SeriaNumer.ToUpper();
            }
            else {
                //DOKRODZAJ.EditValue = NBSP("");
                DOKUBEZP.EditValue = NBSP("");
            }
            Date ur = ph.Urodzony.Data;
            if (ur != Date.Empty)
                URODZONY1.EditValue = URODZONY2.EditValue = string.Format("{0}/{1}/{2}", ur.Day.ToString("D2"), ur.Month.ToString("D2"), ur.Year.ToString("D2"));
            DATA.EditValue = string.Format("{0:D2}/{1:D2}/{2:D2}", DateTime.Today.Day, DateTime.Today.Month, DateTime.Today.Year);
        }

        static readonly string Blank = "&nbsp;";
        static readonly string Empty = "&nbsp;";
        string FormatDate(Date dt, string str) {
            if (dt == Date.MinValue || dt == Date.MaxValue || dt == Date.Empty)
                return string.Empty;
            return string.Format("{0} {1}", str, dt);
        }

        string StripHTML(string HTMLText) {
            var reg = new Regex("<[^>]+>", RegexOptions.IgnoreCase);
            return reg.Replace(HTMLText, "");
        }

        void SetHeader() {
            IPieczątkaFirmy pf = ReportHeader.GetPieczątka(dc);
            dlFirma.EditValue = string.Format("<strong>{0}</strong>", pf.NazwaFormatowana);
            dlAdres1.EditValue = pf.Adres.Linia1;
            dlAdres2.EditValue = pf.Adres.Linia2;
            dlNIP.EditValue = string.Format("NIP: {0}", pf.NIP);
            BusinessModule bm = BusinessModule.GetInstance(dc.Session);
            ReportsLeaf rf = bm.Config.Reports.Defaults;
            string strip = StripHTML(rf.Postscript);
            dlDodatkowe.EditValue = "<font size='1pt'>" + strip + "</font><br/>";
            dlDodatkowe.Visible = !string.IsNullOrEmpty(strip);
        }

        static string Striked(string text) {
            return string.Format("<font size=\"2\" style=\"text-decoration: line-through\">{0}</font>", text);
        }
        void OnContextLoad(Object sender, EventArgs args) {
            SetHeader();
            report = dlTitle;

            dc.LeftMargin = dc.TopMargin = dc.RightMargin = 19;
            dc.BottomMargin = 1;

            Pracownik pracownik = (Pracownik)dc[typeof(Pracownik)];
            PracHistoria ph = pracownik.Last;
            LiczDaneFirmy(ph);
            LiczDanePracownika(ph);

            PlaceModule płace = PlaceModule.GetInstance(pracownik);
            SubTable st = null;
            switch (srpars.WgParam) {
                case WgParametr.WgMiesiącaZUS:
                    st = new SubTable(płace.WypElementy.WgMiesiacZUS[pracownik], pars.Okres);
                    break;
                case WgParametr.WgDatyWypłaty:
                    st = new SubTable(płace.WypElementy.WgDaty[pracownik], pars.Okres);
                    break;
                case WgParametr.WgOkresuListyPłac:
                    st = new SubTable(płace.WypElementy.WgOkresuListy[pracownik], pars.Okres);
                    break;
                case WgParametr.WgOkresuElementu:
                    st = new SubTable(płace.WypElementy.WgPracownik[pracownik], pars.Okres);
                    break;
            }

            int f = 0;
            int t = 0;
            foreach (WypElement element in st) {
                try {
                    int v = 0;
                    switch (srpars.WgParam) {
                        case WgParametr.WgMiesiącaZUS:
                            v = element.MiesiacZUS.Year;
                            break;
                        case WgParametr.WgDatyWypłaty:
                            v = element.Data.Year;
                            break;
                        case WgParametr.WgOkresuListyPłac:
                            v = element.OkresListy.To.Year;
                            break;
                        case WgParametr.WgOkresuElementu:
                            v = element.Okres.To.Year;
                            break;
                    }
                    if (f == 0)
                        f = v;
                    t = v;
                }
                catch { Msg(); }
            }

            if (pars.Okres.From != Date.MinValue && (pars.Okres.From.Year < f || f == 0))
                f = pars.Okres.From.Year;

            if (pars.Okres.To != Date.MaxValue && t < pars.Okres.To.Year)
                t = pars.Okres.To.Year;

            int n = t - f + 1;
            int m = n >= 20 ? n : 20;
            Total[] totals = new Total[m];
            for (int i = 0; i < m; i++)
                totals[i] = new Total(i < n ? f + i : 0, srpars, pars);

            foreach (WypElement element in st) {
                try {
                    int v = 0;
                    switch (srpars.WgParam) {
                        case WgParametr.WgMiesiącaZUS:
                            v = element.MiesiacZUS.Year;
                            break;
                        case WgParametr.WgDatyWypłaty:
                            v = element.Data.Year;
                            break;
                        case WgParametr.WgOkresuListyPłac:
                            v = element.OkresListy.To.Year;
                            break;
                        case WgParametr.WgOkresuElementu:
                            v = element.Okres.To.Year;
                            break;
                    }
                    totals[v - f].Add(element);
                }
                catch { Msg(); }
            }

            var wynagrodzeniaERP7Tab = PobranieDanychWynagrodzeniaERP7ZTabeli(pracownik, srpars).Where(x=> x.Rok >= pars.Okres.From.Year && x.Rok <= pars.Okres.To.Year).ToList();
            var wynagrodzeniaERP7Wyliczone = totals.Cast<ITotal>().ToList();

            foreach (var rok in wynagrodzeniaERP7Tab.Select(x => x.Rok).Distinct())
                wynagrodzeniaERP7Wyliczone.RemoveAll(x => x.Rok == rok);

            wynagrodzeniaERP7Wyliczone.AddRange(wynagrodzeniaERP7Tab);
            wynagrodzeniaERP7Wyliczone = wynagrodzeniaERP7Wyliczone.OrderBy(o => o.Rok != null && o.Rok > 0 ? o.Rok : 9999).ToList();

            Grid1.DataSource = wynagrodzeniaERP7Wyliczone;

            FromTo ftz = ph.Etat.OkresZatrudnienia * pars.Okres;
            if (ftz.To == Date.MaxValue)
                ftz = new FromTo(ftz.From, Date.Today.LastDayYear());
            foreach (FromTo ft in ftz.ToPeriods().BreakByYear())
                PrzekroczeniePodstawy(pracownik, ft.To.ToYearMonth(), wynagrodzeniaERP7Tab);

            if (ph.Etat.OkresZatrudnienia.To == Date.MaxValue)
                JESTZATRUDNIONY.EditValue = "Jest / " + Striked("był") + " zatrudniony";
            else
                JESTZATRUDNIONY.EditValue = Striked("Jest") + " / był zatrudniony";

            ZATRUDNIENIE.EditValue = string.Format("{0} - {1}", ph.Etat.OkresZatrudnienia.From, ph.Etat.OkresZatrudnienia.To != Date.MaxValue ? ph.Etat.OkresZatrudnienia.To.ToString() : "(nadal)");

            Periods okresy = Periods.Empty;
            foreach (PracHistoria h in pracownik.Historia)
                if (h.Etat.Zaszeregowanie.Wymiar < new Fraction(1.0m)) {
                    Date d1 = h.Aktualnosc.From != Date.Empty ? h.Aktualnosc.From : Date.MinValue;
                    Date d2 = (h.Aktualnosc.To != Date.Empty && h.Aktualnosc.To != Date.MaxValue) ? h.Aktualnosc.To : Date.MaxValue;
                    okresy += h.Etat.Okres * new FromTo(d1, d2) * new FromTo(Date.MinValue, new Date(1991, 11, 14));
                }
            okresy = okresy.ToFlat();
            string okr = "";
            foreach (FromTo ft in okresy)
                okr += (okr != "" ? ", " : "") + string.Format("{0} - {1}", ft.From, ft.To);
            OKRESNIEP.EditValue = okr;

            ReportHeader2["PŁEĆ"] = ph.Plec == PłećOsoby.Kobieta ? "Pani" : "Pan";

			List<string> dzieci = new List<string>();
            List<NieobecInfo> lst = new List<NieobecInfo>();
            foreach (OkresNieobecności on in pracownik.Czasy.Nieobecnosci(pars.Okres, true)) {
                KodRSA rsa = on.Definicja.KodRSA;
                if (rsa != null) {
                    string kategoria;
                    switch (rsa.Kod) {
                        case 111:
                        case 112:
                        case 350:
                            if (rsa.Kod == 350 && on.Definicja.Guid != new Guid("00000000-0006-0005-0019-000000000000"))
                                continue;
                            kategoria = "Urlopy bezpłatne"; break;
                        case 121:
                        case 122:
                        case 311:
                        case 319:
                        case 325:
                            if (rsa.Kod == 311 && on.Definicja.Guid != new Guid("00000000-0006-0005-0040-000000000000"))
                                continue;
                            if (rsa.Kod == 319 && on.Definicja.Guid != new Guid("00000000-0006-0005-0045-000000000000"))
                                continue;
                            if (rsa.Kod == 325 && on.Definicja.Guid != new Guid("00000000-0006-0005-0044-000000000000"))
                                continue;
								
							var nb = (Nieobecnosc)on;
                            if (nb != null && nb.CzlonekRodziny != null){
                                var dziecko = string.Format("{0} ur. {1}", nb.CzlonekRodziny.Imie, nb.CzlonekRodziny.Urodzony.Data);
                                if(!dzieci.Contains(dziecko))
                                    dzieci.Add(dziecko);                                                           
                            }														
							
                            kategoria = "Urlopy wychowawcze"; break;
                        default:
                            continue;
                    }
                    lst.Add(new NieobecInfo(on.Definicja.Nazwa.Replace(", hist.", ""), on.Okres, kategoria));
                }
            }

            foreach (WypElement e in st) {
                try {
                    KodRSA rsa = e.KodRSA;
                    if (rsa != null) {
                        string kategoria;
                        switch (rsa.Kod) {
                            case 311:
                            case 319:
                            case 325:
                            case 327:
                                kategoria = "Zasiłki macierzyńskie"; break;
                            case 312:
                                kategoria = "Zasiłki opiekuńcze"; break;
                            case 313:
                            case 314:
                                kategoria = "Zasiłki chorobowe"; break;
                            case 321:
                            case 322:
                                kategoria = "Świadczenia rehabilitacyjne"; break;
                            case 330:
                            case 331:
                            case 332:
                            case 333:
                            case 334:
                                kategoria = "Wynagrodzenia chorobowe"; break;
                            default:
                                continue;
                        }
                        lst.Add(new NieobecInfo(e.Nazwa, e.Okres, kategoria));
                    }
                }
                catch { Msg(); }
            }

            /*
                Nieobecności
                 121,122 - urlop wychowawczy
                 111,112 - urlop bezpłatny
             * Elementy
                311, 327 - zasiłek macierzyński
                312 - zasiłek opiekuńczy
                313, 314 - zasiłek Chorobowy
                321, 322 - Świadczenie rehabilitacyjne
                330...334 - wynagrodzenie chorobowe
              */

            var niewobecnosciTabela = PobranieDanychNieobecnosciERP7ZTabeli(pracownik).Where(x=> x.Okres.From.Year >= pars.Okres.From.Year && x.Okres.To.Year <= pars.Okres.To.Year);
            var niewobecnosciWyliczone = lst;

            foreach (var yearMonth in niewobecnosciTabela.Select(x => x.Okres.ToYearMonth()).Distinct())
                niewobecnosciWyliczone.RemoveAll(x => x.Okres.To.Year == yearMonth.Year);

            niewobecnosciWyliczone.AddRange(niewobecnosciTabela);
            niewobecnosciWyliczone.Sort(new NieobecInfoComparer());


            Grid2.DataSource = niewobecnosciWyliczone;
			
			var pusteZaznaczenie = "\x00A0\x00A0";
			var zaznaczenie = "X";
			var infoZalacznik = "Szczegółowe informacje o okresach nieobecności dostępne są w załączniku do zaświadczenia";
			
			if (niewobecnosciWyliczone.Any(x => x.Kategoria == "Urlopy bezpłatne")) {
				DataLabel100.EditValue = zaznaczenie;
				DataLabel101.EditValue = pusteZaznaczenie;
				InfoLabel01.EditValue = infoZalacznik;
				InfoLabel01.Visible = true;				
			}
			else {
				DataLabel100.EditValue = pusteZaznaczenie;
				DataLabel101.EditValue = zaznaczenie;
				InfoLabel01.Visible = false;
			}
			
			if (niewobecnosciWyliczone.Any(x => x.Kategoria == "Urlopy wychowawcze")) {
				DataLabel1.EditValue = zaznaczenie;
				DataLabel2.EditValue = pusteZaznaczenie;
				InfoLabel02.EditValue = infoZalacznik;
				InfoLabel02.Visible = true;
				
				string tempDz = "";
				foreach(var dz in dzieci){
					tempDz += dz + ", ";
				}
				InfoDzieci.EditValue = tempDz.TrimEnd(new char[] { ' ', ','});
			}
			else {
				DataLabel1.EditValue = pusteZaznaczenie;
				DataLabel2.EditValue = zaznaczenie;
				InfoLabel02.Visible = false;
			}
			
			if (niewobecnosciWyliczone.Any(x => x.Kategoria == "Wynagrodzenia chorobowe")) {
				DataLabel3.EditValue = zaznaczenie;
				DataLabel4.EditValue = pusteZaznaczenie;
				InfoLabel03.EditValue = infoZalacznik;
				InfoLabel03.Visible = true;
			}
			else {
				DataLabel3.EditValue = pusteZaznaczenie;
				DataLabel4.EditValue = zaznaczenie;
				InfoLabel03.Visible = false;
			}
			
			if (niewobecnosciWyliczone.Any(x => x.Kategoria == "Zasiłki chorobowe" || x.Kategoria == "Zasiłki opiekuńcze" || x.Kategoria == "Zasiłki macierzyńskie")) {
				DataLabel5.EditValue = zaznaczenie;
				DataLabel6.EditValue = pusteZaznaczenie;
				InfoLabel04.EditValue = infoZalacznik;
				InfoLabel04.Visible = true;
			}
			else {
				DataLabel5.EditValue = pusteZaznaczenie;
				DataLabel6.EditValue = zaznaczenie;
				InfoLabel04.Visible = false;
			}
			
			if (niewobecnosciWyliczone.Any(x => x.Kategoria == "Świadczenia rehabilitacyjne")) {
				DataLabel7.EditValue = zaznaczenie;
				DataLabel8.EditValue = pusteZaznaczenie;
				InfoLabel05.EditValue = infoZalacznik;
				InfoLabel05.Visible = true;
			}
			else {
				DataLabel7.EditValue = pusteZaznaczenie;
				DataLabel8.EditValue = zaznaczenie;
				InfoLabel05.Visible = false;
			}
        }
        List<NieobecInfo> PobranieDanychNieobecnosciERP7ZTabeli(Pracownik pracownik) {
            List<NieobecInfo> nieobecnosci = new List<NieobecInfo>();
            foreach (var e in pracownik.NieobecnosciERP7.ToList()) {
                Periods okresy = e.Okres.ToPeriods().BreakByYear();
                foreach (FromTo okres in okresy)
                    nieobecnosci.Add(new NieobecInfo(e.Nazwa, okres, GetNameTypKategorieERP7(e.Typ)));
            }
            return nieobecnosci;
        }
          string GetNameTypKategorieERP7(KategorieERP7 kategorieERP7) {
            switch (kategorieERP7) {
                case KategorieERP7.WynagrodzenieChorobowe:
                    return "Wynagrodzenia chorobowe";
                case KategorieERP7.SwiadczenieRehabilitacyjne:
                    return "Świadczenia rehabilitacyjne";
                case KategorieERP7.ZasilkiChorobowe:
                    return "Zasiłki chorobowe";
                case KategorieERP7.ZasilkiOpiekuncze:
                    return "Zasiłki opiekuńcze";
                case KategorieERP7.ZasilkiMacierzynskie:
                    return "Zasiłki macierzyńskie";
                case KategorieERP7.UrlopyWychowawcze:
                    return "Urlopy wychowawcze";
                case KategorieERP7.UrlopyBezplatne:
                    return "Urlopy bezpłatne";
                default:
                    return "";
            }
        }

        List<ITotal> PobranieDanychWynagrodzeniaERP7ZTabeli(Pracownik pracownik, SrParams srParams) {
            List<Total2> wynagrodzeniaERP7 = new List<Total2>();
            foreach (var e in pracownik.WynagrodzeniaERP7.ToList()) {
                wynagrodzeniaERP7.Add(new Total2(e));
            }
            return wynagrodzeniaERP7.Cast<ITotal>().ToList();
        }

        protected void Grid1_BeforeRow(object sender, RowEventArgs args) {
            ITotal total = (ITotal)args.Row;

            //decimal stałeZmienne = total.Stałe + total.Zmienne;
            //colStałeZmienne.EditValue = stałeZmienne;
            colInne.AddLine(total.Inne);
            colInneOpis.AddLine(total.InneOpis == "" ? "&nbsp;" : total.InneOpis);
        }

        int DLP = 0;
        void PrzekroczeniePodstawy(Pracownik pracownik, YearMonth miesiąc, List<ITotal> wynagrodzeniaERP7) {
            DataLabel[] DLR = { PR1, PR2, PR3, PR4, PR5, PR6, PR7, PR8, PR9, PR10, PR11, PR12, PR13, PR14, PR15, PR16, PR17, PR18, PR19, PR20 };
            DataLabel[] DLM = { PM1, PM2, PM3, PM4, PM5, PM6, PM7, PM8, PM9, PM10, PM11, PM12, PM13, PM14, PM15, PM16, PM17, PM18, PM19, PM20 };
            decimal[] mpe = new decimal[13];
            decimal[] mpc = new decimal[13];

            YearMonth start = new YearMonth(miesiąc.Year, 1);

            PlaceModule płace = PlaceModule.GetInstance(dc);
            SubTable st = płace.WypElementy.WgMiesiacZUS[pracownik];
            st = new SubTable(st, new FromTo(start.FirstDay, miesiąc.LastDay));

            foreach (WypElement e in st) {
                int m = e.MiesiacZUS.Month;
                mpe[m] += e.Podatki.Emerytalna.Podstawa;
                mpc[m] += e.Podatki.Chorobowa.Podstawa;
            }

            YearMonth przekroczenie = YearMonth.Empty;
            var _przekroczenieElem = wynagrodzeniaERP7.FirstOrDefault(x => x.Rok == miesiąc.Year && x.MiesiacPrzekroczeniaZUS != 0);
            if (_przekroczenieElem != null) {
                przekroczenie = new YearMonth(_przekroczenieElem.Rok, _przekroczenieElem.MiesiacPrzekroczeniaZUS);
            }
            else {
                for (int m = start.Month; m <= miesiąc.Month; m++) {
                    if (mpe[m] != mpc[m]) {
                        przekroczenie = start + (m - 1);
                        break;
                    }
                }
            }

            if ((przekroczenie != YearMonth.Empty) && DLP < DLR.Length) {
                    DLR[DLP].EditValue = przekroczenie.Year;
                    DLM[DLP].EditValue = przekroczenie.Month;

                DLP++;
            }
        }

        public static DataLabel report;

        public static void Msg() {
            if (report == null) return;
            string msg = "Wydruk przygotowany na podstawie danych, do których operator ma prawa dostępu";
            if (report.EditValue == null || !report.EditValue.ToString().Contains(msg))
                report.EditValue = msg;
        }
    </script>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
    <meta content="C#" name="CODE_LANGUAGE">
    <meta content="JavaScript" name="vs_defaultClientScript">
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
</head>
<body style="font-family: Tahoma">
    <form id="DeklaracjaERP7" method="post" runat="server">
        <ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad"></ea:datacontext>

        <ea:SectionMarker ID="SectionMarker9" runat="server"></ea:SectionMarker>
        <ea:PageBreak ID="PageBreak1" runat="server" BreakFirstTimes="False"
            ResetPageCounter="True">
        </ea:PageBreak>
        <ea:Section runat="server" SectionType="Header"></ea:Section>
        <ea:Section runat="server" SectionType="Body">

            <p align="right">
                <b>ERP-7</b>
            </p>

            <table cellspacing="0" width="100%" style="border-width: 0px 0px 0px 0px; border-style: solid; border-color: silver; font-family: tahoma; text-align: left;">
                <tr>
                    <td width="35%" valign="top" align="left" style="border-width: 0px 0px 0px 0px; border-style: solid; border-color: silver; font-size: 9pt;">
                        <ea:datalabel id="dlFirma" runat="server" Bold="false"></ea:datalabel><br />
                        <ea:datalabel id="dlAdres1" runat="server" Bold="false"></ea:datalabel><br />
                        <ea:datalabel id="dlAdres2" runat="server" Bold="false"></ea:datalabel><br />
                        <ea:datalabel id="dlNIP" runat="server" Bold="false"></ea:datalabel><br />
                        <ea:datalabel id="dlDodatkowe" runat="server" Bold="false"></ea:datalabel>
                        ....................................................................<br />
                        Pieczątka płatnika składek, jeśli ją posiadasz<br />
                        lub podmiotu upoważnionego/ uprawnionego<br />
                    </td>
                </tr>
            </table>
            <br />

            <p align="center">
                <b>ZAŚWIADCZENIE<br />
                    O ZATRUDNIENIU I WYNAGRODZENIU</b><br />
                <ea:datalabel id="dlTitle" runat="server" Bold="false"></ea:datalabel>
            </p>

            <font face="Tahoma" size="2">
                <p style="text-align: left">
                    <u><b>Instrukcja wypełniania</b></u><br />
                </p>
                <p style="text-align: justify">
                    Szczególnie starannie wypełnij sekcję dotyczącą kwot wynagrodzenia/ uposażenia oraz kwot świadczeń wypłaconych
                    w okresie niezdolności do pracy i innych należności – uwzględnianych przy ustalaniu podstawy wymiaru emerytury,
                    renty oraz kapitału początkowego.<br />
                    Pamiętaj, że dane przekazane w tym formularzu mogą mieć wpływ na wysokość świadczenia przysługującego
                    pracownikowi, dla którego wystawiasz to zaświadczenie. Dane te pozwolą również ustalić podstawę wymiaru
                    świadczenia, w oparciu o obowiązujące regulacje prawne, zgodnie z którymi przy ustalaniu łącznej kwoty przychodu
                    za poszczególne lata kalendarzowe, dany przychód doliczany jest do roku, za który był należny.<br />
                </p>
                1. Wypełnij WIELKIMI LITERAMI<br />
                2. Wypełnij kolorem czarnym lub niebieskim (nie ołówkiem)<br />
                3. Zanim wypełnisz zaświadczenie, zapoznaj się z dołączoną do niego <b>Informacją</b><br />
            </font>
            <br />
            <font face="Tahoma" size="2">
                <u><b>Dane płatnika składek</b></u><br />
                <table cellspacing="0" cellpadding="0" width="95%" border="0">
                    <tr>
                        <td width="35%" align="right"><font size="2">NIP</font></td>
                        <td width="3%">&nbsp;</td>
                        <td width="62%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="2">
                                <ea:DataLabel ID="FirmaNIP" runat="server"></ea:DataLabel></font>
                        </td>
                    </tr>
                    <tr>
                        <td width="35%" align="right"><font size="2">Numer REGON</font></td>
                        <td width="3%">&nbsp;</td>
                        <td width="62%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="2">
                                <ea:DataLabel ID="FirmaREGON" runat="server"></ea:DataLabel></font>
                        </td>
                    </tr>
                    <tr>
                        <td width="35%" align="right">&nbsp;</td>
                        <td width="3%">&nbsp;</td>
                        <td width="62%">
                            <font size="1"><i>Jeśli nie podałeś NIP, podaj REGON</i></font>
                        </td>
                    </tr>
                    <tr>
                        <td width="35%" align="right"><font size="2">PESEL</font></td>
                        <td width="3%">&nbsp;</td>
                        <td width="62%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="2">
                                <ea:DataLabel ID="FirmaPESEL" runat="server"></ea:DataLabel></font>
                        </td>
                    </tr>
                    <tr>
                        <td width="35%" align="right">&nbsp;</td>
                        <td width="3%">&nbsp;</td>
                        <td width="62%">
                            <font size="1"><i>Jeśli nie masz nadanego NIP i REGON, podaj numer PESEL</i></font>
                        </td>
                    </tr>
                    <tr>
                        <td width="35%" align="right"><font size="2">Rodzaj, seria i numer dokumentu<br />
                            potwierdzającego tożsamość</font></td>
                        <td width="3%">&nbsp;</td>
                        <td width="62%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="2">
                                <ea:DataLabel id="FirmaRodzaj" runat="server"></ea:DataLabel>&nbsp;
							<ea:DataLabel id="FirmaDokument" runat="server"></ea:DataLabel></font>
                        </td>
                    </tr>
                    <tr>
                        <td width="35%" align="right">&nbsp;</td>
                        <td width="3%">&nbsp;</td>
                        <td width="62%">
                            <font size="1"><i>Jeśli nie masz nadanego NIP, REGON i numeru PESEL, podaj serię i numer dokumentu potwierdzającego tożsamość</i></font>
                        </td>
                    </tr>
                    <tr>
                        <td width="35%" align="right"><font size="2">Nazwa albo imię i nazwisko</font></td>
                        <td width="3%">&nbsp;</td>
                        <td width="62%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="2">
                                <ea:DataLabel ID="FirmaNazwa" runat="server"></ea:DataLabel></font>
                        </td>
                    </tr>
                    <tr>
                        <td width="35%" align="right"><font size="2">Ulica</font></td>
                        <td width="3%">&nbsp;</td>
                        <td width="62%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="2">
                                <ea:DataLabel ID="FirmaUlica" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></font>
                        </td>
                    </tr>
                </table>
                <table cellspacing="0" cellpadding="0" width="95%" border="0">
                    <tr>
                        <td width="35%" align="right"><font size="2">Numer domu</font></td>
                        <td width="3%">&nbsp;</td>
                        <td width="20%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="2">
                                <ea:DataLabel ID="FirmaNrDomu" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></font>
                        </td>
                        <td width="20%" align="right"><font size="2">Numer lokalu</font></td>
                        <td width="2%">&nbsp;</td>
                        <td width="20%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="2">
                                <ea:DataLabel ID="FirmaNrLokalu" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></font>
                        </td>
                    </tr>
                    <tr>
                        <td width="35%" align="right"><font size="2">Kod pocztowy</font></td>
                        <td width="3%">&nbsp;</td>
                        <td width="20%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="2">
                                <ea:DataLabel ID="FirmaKodP" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></font>
                        </td>
                        <td width="20%" align="right"><font size="2">Miejscowość</font></td>
                        <td width="2%">&nbsp;</td>
                        <td width="20%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="2">
                                <ea:DataLabel ID="FirmaMiejscowosc" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></font>
                        </td>
                    </tr>
                </table>
                <table cellspacing="0" cellpadding="0" width="95%" border="0">
                    <tr>
                        <td width="35%" align="right"><font size="2">Nazwa państwa</font></td>
                        <td width="3%">&nbsp;</td>
                        <td width="62%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="2">
                                <ea:DataLabel ID="FirmaKraj" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></font>
                        </td>
                    </tr>
                    <tr>
                        <td width="35%" align="right">&nbsp;</td>
                        <td width="3%">&nbsp;</td>
                        <td width="62%">
                            <font size="1"><i>Podaj, jeśli Twój adres jest inny niż polski</i></font>
                        </td>
                    </tr>
                    <tr>
                        <td width="35%" align="right"><font size="2">Numer Konta Płatnika (NKP)<br />
                            przed 1999 r. </font></td>
                        <td width="3%">&nbsp;</td>
                        <td width="62%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="2">
                                <ea:DataLabel ID="EMPTY" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></font>
                        </td>
                    </tr>
                    <tr>
                        <td width="35%" align="right">&nbsp;</td>
                        <td width="3%">&nbsp;</td>
                        <td width="62%">
                            <font size="1"><i>Podaj, jeśli do 31 grudnia 1998 r. zgłaszałeś pracowników do ubezpieczenia społecznego w deklaracjach rozliczeniowych imiennych</i></font>
                        </td>
                    </tr>
                </table>
            </font>
            <br />
            <font face="Tahoma" size="2">
                <u><b>Dane osoby ubezpieczonej - pracownika</b></u><br />
                <table cellspacing="0" cellpadding="0" width="95%" border="0">
                    <tr>
                        <td width="35%" align="right"><font size="2">PESEL</font></td>
                        <td width="3%">&nbsp;</td>
                        <td width="62%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="2">
                                <ea:DataLabel DataMember="PracHistoria.PESEL" runat="server"></ea:DataLabel></font>
                        </td>
                    </tr>
                    <tr>
                        <td width="35%" align="right"><font size="2">Rodzaj, seria i numer dokumentu<br />
                            potwierdzającego tożsamość</font></td>
                        <td width="3%">&nbsp;</td>
                        <td width="62%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="2">
                                <ea:DataLabel id="DOKRODZAJ" runat="server"></ea:DataLabel>&nbsp;
							<ea:DataLabel id="DOKUBEZP" runat="server"></ea:DataLabel></font>
                        </td>
                    </tr>
                    <tr>
                        <td width="35%" align="right">&nbsp;</td>
                        <td width="3%">&nbsp;</td>
                        <td width="62%">
                            <font size="1"><i>Jeśli nie ma nadanego numeru PESEL, podaj serię i numer dokumentu potwierdzającego tożsamość</i></font>
                        </td>
                    </tr>
                    <tr>
                        <td width="35%" align="right"><font size="2">Imię i nazwisko</font></td>
                        <td width="3%">&nbsp;</td>
                        <td width="62%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="2">
                                <ea:DataLabel ID="PracImieNazwisko1" runat="server"></ea:DataLabel></font>
                        </td>
                    </tr>
                    <tr>
                        <td width="35%" align="right"><font size="2">Data urodzenia</font></td>
                        <td width="3%">&nbsp;</td>
                        <td width="62%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="2">
                                <ea:DataLabel ID="URODZONY1" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></font>
                        </td>
                    </tr>
                    <tr>
                        <td width="35%" align="right">&nbsp;</td>
                        <td width="3%">&nbsp;</td>
                        <td width="62%">
                            <font size="1"><b>dd / mm / rrrr</b></font>
                        </td>
                    </tr>
                </table>
            </font>
            <br />
            <ea:PageBreak id="PageBreak2" runat="server" Required="True"></ea:PageBreak>
            <font face="Tahoma" size="2">
                <u><b>Informacje o pracowniku</b></u><br />
                <br />
                <table cellspacing="0" cellpadding="0" width="95%" border="0">
                    <tr>
                        <td width="27%">
                            <font size="2">1. 
					            <ea:DataLabel id="JESTZATRUDNIONY" runat="server"></ea:DataLabel>
                            </font>
                        </td>
                        <td width="3%">&nbsp;</td>
                        <td width="70%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="2">
                                <ea:DataLabel id="ZATRUDNIENIE" runat="server"></ea:DataLabel>
                                <br />
                            </font>
                        </td>
                    </tr>
                    <tr>
                        <td width="27%"></td>
                        <td width="3%"></td>
                        <td width="70%">
                            <font size="1">Podaj datę, od kiedy jest zatrudniony lub okres zatrudnienia od–do</font>
                        </td>
                    </tr>
                </table>
                <br />
                <table cellspacing="0" cellpadding="0" width="95%" border="0">
                    <tr>
                        <td width="100%">
                            <font size="2">2. Niepełny wymiar czasu pracy przed 15 listopada 1991 r.</font>
                        </td>
                    </tr>
                    <tr>
                        <td width="100%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="2">
                                <ea:DataLabel id="OKRESNIEP" runat="server"></ea:DataLabel>
                                <br />
                                <br />
                            </font>
                        </td>
                    </tr>
                    <tr>
                        <td width="100%">
                            <font size="1">Wypełnij, jeśli pracownik przed 15 listopada 1991 r. był zatrudniony w niepełnym wymiarze czasu pracy. Podaj okres od–do, w którym
                                pracownik przed 15 listopada 1991 r. był zatrudniony w niepełnym wymiarze czasu pracy oraz wymiar czasu pracy
                            </font>
                        </td>
                    </tr>
                </table>
                <br />
                <table cellspacing="0" cellpadding="0" width="95%" border="0">
                    <tr>
                        <td width="80%">
                            <font size="2">3. Pracownikowi udzielono urlopu bezpłatnego</font>
                        </td>
                        <td width="2%">&nbsp;</td>
                        <td width="8%"><font size="2">[<ea:DataLabel ID="DataLabel100" runat="server"></ea:DataLabel>] TAK</font>
                        </td>
                        <td width="2%">&nbsp;</td>
                        <td width="8%"><font size="2">[<ea:DataLabel ID="DataLabel101" runat="server"></ea:DataLabel>] NIE</font>
                        </td>
                    </tr>
                </table>
                <table cellspacing="0" cellpadding="0" width="95%" border="0">
                    <tr>
                        <td width="100%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="2">
                                <ea:DataLabel ID="InfoLabel01" runat="server"></ea:DataLabel><br />
                                <br />
                            </font>
                        </td>
                    </tr>
                    <tr>
                        <td width="100%">
                            <font size="1">Jeśli <b>TAK</b>, podaj okresy od–do</font>
                        </td>
                    </tr>
                </table>
                <br />
                <table cellspacing="0" cellpadding="0" width="95%" border="0">
                    <tr>
                        <td width="80%">
                            <font size="2">4. Pracownikowi udzielono urlopu wychowawczego/ urlopu bezpłatnego na wychowywanie dzieci</font>
                        </td>
                        <td width="2%">&nbsp;</td>
                        <td width="8%"><font size="2">[<ea:DataLabel ID="DataLabel1" runat="server"></ea:DataLabel>] TAK</font>
                        </td>
                        <td width="2%">&nbsp;</td>
                        <td width="8%"><font size="2">[<ea:DataLabel ID="DataLabel2" runat="server"></ea:DataLabel>] NIE</font>
                        </td>
                    </tr>
                </table>
                <table cellspacing="0" cellpadding="0" width="95%" border="0">
                    <tr>
                        <td width="100%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="2">
                                <ea:DataLabel ID="InfoLabel02" runat="server"></ea:DataLabel><br />
                                <br />
                            </font>
                        </td>
                    </tr>
                    <tr>
                        <td width="100%">
                            <font size="1">Jeśli <b>TAK</b>, podaj okresy od–do</font>
                        </td>
                    </tr>
                    <tr>
                        <td width="100%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="2">
                                <ea:DataLabel ID="InfoDzieci" runat="server"></ea:DataLabel><br />
                                <br />
                            </font>
                        </td>
                    </tr>
                    <tr>
                        <td width="100%">
                            <font size="1">Podaj imię i datę urodzenia dziecka/ dzieci</font>
                        </td>
                    </tr>
                </table>
                <br />
                <u><b>Informacje o wypłaconych świadczeniach</b></u><br />
                <br />
                <table cellspacing="0" cellpadding="0" width="95%" border="0">
                    <tr>
                        <td width="80%">
                            <font size="2">1. Pracownikowi wypłacono wynagrodzenie za czas niezdolności do pracy na podstawie art. 92 Kodeksu pracy lub innych odrębnych przepisów</font>
                        </td>
                        <td width="2%">&nbsp;</td>
                        <td width="8%"><font size="2">[<ea:DataLabel ID="DataLabel3" runat="server"></ea:DataLabel>] TAK</font>
                        </td>
                        <td width="2%">&nbsp;</td>
                        <td width="8%"><font size="2">[<ea:DataLabel ID="DataLabel4" runat="server"></ea:DataLabel>] NIE</font>
                        </td>
                    </tr>
                </table>
                <table cellspacing="0" cellpadding="0" width="95%" border="0">
                    <tr>
                        <td width="100%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="2">
                                <ea:DataLabel ID="InfoLabel03" runat="server"></ea:DataLabel><br />
                                <br />
                            </font>
                        </td>
                    </tr>
                    <tr>
                        <td width="100%">
                            <font size="1">Jeśli <b>TAK</b>, podaj okresy od–do</font>
                        </td>
                    </tr>
                </table>
                <br />
                <table cellspacing="0" cellpadding="0" width="95%" border="0">
                    <tr>
                        <td width="80%">
                            <font size="2">2. Pracownikowi po 14 listopada 1991 r. wypłacono zasiłek chorobowy/ opiekuńczy/ macierzyński</font>
                        </td>
                        <td width="2%">&nbsp;</td>
                        <td width="8%"><font size="2">[<ea:DataLabel ID="DataLabel5" runat="server"></ea:DataLabel>] TAK</font>
                        </td>
                        <td width="2%">&nbsp;</td>
                        <td width="8%"><font size="2">[<ea:DataLabel ID="DataLabel6" runat="server"></ea:DataLabel>] NIE</font>
                        </td>
                    </tr>
                </table>
                <table cellspacing="0" cellpadding="0" width="95%" border="0">
                    <tr>
                        <td width="100%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="2">
                                <ea:DataLabel ID="InfoLabel04" runat="server"></ea:DataLabel><br />
                                <br />
                                <br />
                                <br />
                                <br />
                                <br />
                                <br />
                                <br />
                            </font>
                        </td>
                    </tr>
                    <tr>
                        <td width="100%">
                            <font size="1">Jeśli <b>TAK</b>, podaj okresy od–do</font>
                        </td>
                    </tr>
                </table>
                <br />
                <table cellspacing="0" cellpadding="0" width="95%" border="0">
                    <tr>
                        <td width="80%">
                            <font size="2">3. Pracownikowi wypłacono świadczenie rehabilitacyjne</font>
                        </td>
                        <td width="2%">&nbsp;</td>
                        <td width="8%"><font size="2">[<ea:DataLabel ID="DataLabel7" runat="server"></ea:DataLabel>] TAK</font>
                        </td>
                        <td width="2%">&nbsp;</td>
                        <td width="8%"><font size="2">[<ea:DataLabel ID="DataLabel8" runat="server"></ea:DataLabel>] NIE</font>
                        </td>
                    </tr>
                </table>
                <table cellspacing="0" cellpadding="0" width="95%" border="0">
                    <tr>
                        <td width="100%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="2">
                                <ea:DataLabel ID="InfoLabel05" runat="server"></ea:DataLabel><br />
                                <br />
                            </font>
                        </td>
                    </tr>
                    <tr>
                        <td width="100%">
                            <font size="1">Jeśli <b>TAK</b>, podaj okresy od–do</font>
                        </td>
                    </tr>
                </table>
                <br />
                <p style="text-align: justify">
                    <b>Jeśli w części dotyczącej ww. okresów brakuje miejsca na wpisanie wszystkich okresów – brakujące okresy wykaż odrębnie
                    w załączniku do zaświadczenia. Załącznik ten stanowi wówczas integralną część zaświadczenia i powinien być opatrzony
                    pieczątką płatnika składek, jeśli ją posiadasz/ upoważnionego podmiotu oraz podpisem i pieczątką tej samej osoby, która
                    wystawiła zaświadczenie.</b>
                </p>
                <br />
                <table cellspacing="0" cellpadding="0" width="95%" border="0">
                    <tr>
                        <td width="15%">
                            <font size="2">Imię i nazwisko pracownika</font>
                        </td>
                        <td width="3%">&nbsp;</td>
                        <td width="40%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="2">
                                <ea:DataLabel ID="PracImieNazwisko2" runat="server"></ea:DataLabel></font>
                        </td>
                        <td width="5%">&nbsp;</td>
                        <td width="12%">
                            <font size="2">Data urodzenia</font>
                        </td>
                        <td width="3%">&nbsp;</td>
                        <td width="22%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="2">
                                <ea:DataLabel ID="URODZONY2" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></font>
                        </td>
                    </tr>
                    <tr>
                        <td width="15%">&nbsp;</td>
                        <td width="3%">&nbsp;</td>
                        <td width="40%">&nbsp;</td>
                        <td width="5%">&nbsp;</td>
                        <td width="12%">&nbsp;</td>
                        <td width="3%">&nbsp;</td>
                        <td width="22%"><font size="1"><b>dd / mm /rr</b></font></td>
                    </tr>
                </table>
            </font>
            <ea:PageBreak id="PageBreak4" runat="server" Required="True"></ea:PageBreak>
            <br />
            <font face="Tahoma" size="2">
                <p style="text-align: justify">
                    <b>Informacje o kwotach wynagrodzenia/ uposażenia, kwotach świadczeń wypłaconych w okresie niezdolności do
                    pracy oraz kwotach innych należności – za dany rok kalendarzowy – uwzględnianych przy ustalaniu podstawy
                    wymiaru emerytury, renty oraz kapitału początkowego</b>
                </p>
                <p style="text-align: justify">
                    <font face="Tahoma" size="1">
                        <b>WAŻNE!</b> Przy wypełnianiu poniższej tabeli, kwoty stałych i zmiennych składników wynagrodzenia/ uposażenia (stałe wynagrodzenie zasadnicze,
                        premie, nagrody, wartość świadczeń w naturze, dodatki do płac i inne) oraz kwoty świadczeń za okres niezdolności do pracy – jeżeli wypłacone
                        zostały w innym roku niż rok kalendarzowy, za który są należne – dolicz do roku, za który przysługują. Pamiętaj również o wyłączeniu tych kwot
                        z roku, w którym zostały wypłacone.<br />
                        Jeśli nie jest możliwe ustalenie okresu, za jaki przysługuje dana wypłata – dolicz ją do roku, w którym została wypłacona. 
                    </font>
                </p>
                <ea:Grid id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" WithSections="False" ColumnHeaderFontBold="False" ColumnHeaderFontSize="7">
                    <columns>
						<ea:GridColumn ID="GridColumn1" Width="7" Align="Center" DataMember="Rok" Caption="Rok|(1)" HideZero="True" runat="server"></ea:GridColumn>
						
                        <ea:GridColumn Align="Right" Caption="<b>Kwoty</b> stałych i zmiennych składników wynagrodzenia/ uposażenia – należnych za dany rok kalendarzowy, które stanowiły podstawę wymiaru składek na ubezpieczenie społeczne/ ubezpieczenia emerytalne i rentowe|(2)" 
                            HideZero="True" Format="{0:n}" runat="server" DataMember="StałeZmienne"></ea:GridColumn>

						<ea:GridColumn ID="GridColumn2" Align="Right" DataMember="ChoroboweZasiłki" Caption="<b>Kwoty</b> świadczeń należnych za dany rok kalendarzowy (wynagrodzenia za czas niezdolności do pracy, zasiłków: chorobowego, opiekuńczego, macierzyńskiego)|(3)"
							HideZero="True" Format="{0:n}" runat="server"></ea:GridColumn>
						
                        <ea:GridColumn ID="GridColumn6" Width="13" Align="Right" DataMember="UrlopyRehab" Caption="<b>Kwoty</b> świadczeń – należnych za dany rok kalendarzowy (świadczenia rehabilitacyjnego/ zasiłku/ świadczenia/ dodatku – wyrównawczego)|(4)"
							HideZero="True" Format="{0:n}" runat="server"></ea:GridColumn>
												
                        <ea:GridColumn ID="GridColumn4" Width="10" Align="Right" DataMember="SkładkiBezZus" Caption="<b>Kwoty</b> składników wynagrodzenia – należnych za dany rok kalendarzowy, wypłaconych obok wynagrodzenia za czas niezdolności do pracy, zasiłku chorobowego, macierzyńskiego, opiekuńczego, świadczenia rehabilitacyjnego, które w okresie pobierania ww. świadczeń nie stanowiły podstawy wymiaru składek na ubezpieczenie społeczne/ ubezpieczenia emerytalne i rentowe|(5)"
							HideZero="True" Format="{0:n}" runat="server"></ea:GridColumn>
												
                        <ea:GridColumn Width="13" Align="Right" DataMember="PonadLimit" Caption="<b>Kwoty</b> przychodu należnego za dany rok kalendarzowy, który nie stanowił podstawy wymiaru składek na ubezpieczenia emerytalne i rentowe, a stanowił podstawę wymiaru składek na ubezpieczenie wypadkowe (dotyczy lat po 1998 r.)|(6)"
							HideZero="True" Format="{0:n}" runat="server"></ea:GridColumn>

                        <ea:GridColumn Align="Right" Caption="<br><br><br><br><br><br><br><br><br><b>Kwoty</b> innych wypłaconych należności, które nie zostały wykazane w kolumnach 2–6 i ich rodzaj – o ile są one wliczane do podstawy wymiaru świadczeń|(7)<br><br><br>~kwota"
							HideZero="True" Format="{0:n}" ID="colInne" runat="server" VAlign="Top"></ea:GridColumn>
						
                        <ea:GridColumn Align="Center" Caption="<br><br><br><br><br><br><br><br><br><b>Kwoty</b> innych wypłaconych należności, które nie zostały wykazane w kolumnach 2–6 i ich rodzaj – o ile są one wliczane do podstawy wymiaru świadczeń|(7)<br><br><br>~rodzaj" 
                            ID="colInneOpis" runat="server" ></ea:GridColumn>
					</columns>
                </ea:Grid>
                <br />
                <u><b>Informacja o przekroczeniu rocznej podstawy wymiaru składek na ubezpieczania emerytalne i rentowe</b></u><br />
                <font face="Tahoma" size="1">Wypełnij wyłącznie w przypadku przekroczenia przez pracownika rocznej podstawy wymiaru składek na ubezpieczenia emerytalne i rentowe<br />
                </font>
                <br />
                <table cellspacing="0" cellpadding="0" width="100%" border="0">
                    <tr>
                        <td width="5%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">Rok</font>
                        </td>
                        <td width="20%" style="text-align: center; border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">Miesiąc</font>
                        </td>
                        <td width="5%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">Rok</font>
                        </td>
                        <td width="20%" style="text-align: center; border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">Miesiąc</font>
                        </td>
                        <td width="5%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">Rok</font>
                        </td>
                        <td width="20%" style="text-align: center; border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">Miesiąc</font>
                        </td>
                        <td width="5%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">Rok</font>
                        </td>
                        <td width="20%" style="text-align: center; border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">Miesiąc</font>
                        </td>
                    </tr>
                    <tr>
                        <td width="5%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PR1" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="20%" style="text-align: center; border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PM1" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="5%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PR2" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="20%" style="text-align: center; border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PM2" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="5%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PR3" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="20%" style="text-align: center; border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PM3" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="5%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PR4" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="20%" style="text-align: center; border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PM4" runat="server"></ea:datalabel></font><br />
                        </td>
                    </tr>
                    <tr>
                        <td width="5%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PR5" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="20%" style="text-align: center; border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PM5" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="5%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PR6" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="20%" style="text-align: center; border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PM6" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="5%" style="text-align: center; border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PR7" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="20%" style="text-align: center; border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PM7" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="5%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PR8" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="20%" style="text-align: center; border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PM8" runat="server"></ea:datalabel></font><br />
                        </td>
                    </tr>
                    <tr>
                        <td width="5%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PR9" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="20%" style="text-align: center; border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PM9" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="5%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PR10" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="20%" style="text-align: center; border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PM10" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="5%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PR11" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="20%" style="text-align: center; border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PM11" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="5%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PR12" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="20%" style="text-align: center; border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PM12" runat="server"></ea:datalabel></font><br />
                        </td>
                    </tr>
                    <tr>
                        <td width="5%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PR13" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="20%" style="text-align: center; border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PM13" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="5%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PR14" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="20%" style="text-align: center; border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PM14" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="5%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PR15" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="20%" style="text-align: center; border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PM15" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="5%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PR16" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="20%" style="text-align: center; border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PM16" runat="server"></ea:datalabel></font><br />
                        </td>
                    </tr>
                    <tr>
                        <td width="5%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PR17" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="20%" style="text-align: center; border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PM17" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="5%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PR18" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="20%" style="text-align: center; border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PM18" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="5%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PR19" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="20%" style="text-align: center; border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PM19" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="5%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PR20" runat="server"></ea:datalabel></font><br />
                        </td>
                        <td width="20%" style="text-align: center; border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="1">
                                <ea:datalabel id="PM20" runat="server"></ea:datalabel></font><br />
                        </td>
                    </tr>
                </table>
                <font face="Tahoma" size="1">Podaj rok i miesiąc, w którym nastąpiło przekroczenie przez pracownika rocznej podstawy wymiaru składek na ubezpieczenia emerytalne i rentowe<br />
                </font>
                <ea:PageBreak id="PageBreak15" runat="server" Required="True"></ea:PageBreak>
                <br />
                <br />
                <u><b>Dodatkowe informacje/ uwagi</b></u><br />
                <table cellspacing="0" cellpadding="0" width="95%" border="0">
                    <tr>
                        <td width="100%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="2">
                                <br />
                                <br />
                                <br />
                                <br />
                            </font>
                        </td>
                    </tr>
                </table>
                <font face="Tahoma" size="1">Podaj składnik wynagrodzenia, co do którego masz wątpliwości, czy jest on uwzględniany w podstawie wymiaru świadczeń i którego nie wykazałeś
                    w tabeli na str. 3. Podaj rodzaj tego składnika, kwotę, tytuł wypłaty oraz okres, w którym został wypłacony. Możesz również zgłosić inne uwagi
                    dotyczące danych, które podałeś w zaświadczeniu.
                    <br />
                </font>
            </font>
            <font face="Tahoma" size="2">
                <br />
                <u><b>Informacje dotyczące pełnomocnika upoważnionego przez płatnika składek do wystawienia zaświadczenia</b></u><br />
                <table cellspacing="0" cellpadding="0" width="95%" border="0">
                    <tr>
                        <td width="100%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="2">
                                <br />
                                <br />
                                <br />
                                <br />
                            </font>
                        </td>
                    </tr>
                </table>
                <font face="Tahoma" size="1">Jako podmiot upoważniony do wystawienia niniejszego zaświadczenia podaj: nazwę i adres firmy, REGON i NIP, zakres udzielonego
                    pełnomocnictwa i termin jego obowiązywania<br />
                </font>
                <br />
                <u><b>Informacja o dokumentach</b></u><br />
                <table cellspacing="0" cellpadding="0" width="95%" border="0">
                    <tr>
                        <td width="100%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="2">
                                <br />
                                <br />
                                <br />
                                <br />
                            </font>
                        </td>
                    </tr>
                </table>
                <font face="Tahoma" size="1">Podaj na podstawie jakich dokumentów wystawiłeś zaświadczenie<br />
                </font>
                <br />
                <u><b>Załączniki</b></u><br />
                Przedkładam: Załącznik uzupełniający informację o okresach wypłacania świadczeń (uzupełnienie sekcji: Informacje o wypłaconych świadczeniach)
				<table cellspacing="0" cellpadding="0" width="95%" border="0">
                    <tr>
                        <td width="8%"><font size="2">[<ea:DataLabel ID="DataLabel9" runat="server"></ea:DataLabel>&nbsp;&nbsp;] TAK</font>
                        </td>
                        <td width="2%">&nbsp;</td>
                        <td width="8%"><font size="2">[<ea:DataLabel ID="DataLabel10" runat="server"></ea:DataLabel>&nbsp;&nbsp;] NIE</font>
                        </td>
                    </tr>
                </table>
                <br />
                <u><b>Odpowiedzialność za wystawienie zaświadczenia</b></u><br />
                <b>Wystawienie zaświadczenia niezgodnego z prawdą pociąga za sobą odpowiedzialność przewidzianą w odpowiednich przepisach prawa.</b><br />
                <br />
                <table cellspacing="0" cellpadding="0" width="95%" border="0">
                    <tr>
                        <td width="12%">
                            <font size="2">Data</font>
                        </td>
                        <td width="2%">&nbsp;</td>
                        <td width="25%" style="border-right: silver 1px solid; border-top: silver 1px solid; border-left: silver 1px solid; border-bottom: silver 1px solid">
                            <font size="2">
                                <ea:DataLabel ID="DATA" runat="server"></ea:DataLabel></font>
                        </td>
                        <td width="5%">&nbsp;</td>
                        <td width="55%" style="border-bottom: silver 1px solid">
                            <font size="2">
                                <br />
                            </font>
                        </td>
                    </tr>
                    <tr>
                        <td width="12%">&nbsp;</td>
                        <td width="2%">&nbsp;</td>
                        <td width="25%">
                            <font size="1"><b>dd / mm /rr</b></font>
                        </td>
                        <td width="5%">&nbsp;</td>
                        <td width="55%">
                            <p style="text-align: center">
                                <font size="1">Podpis płatnika składek lub osoby upoważnionej/ uprawnionej do wystawienia
                                zaświadczenia – nr telefonu oraz pieczątka zawierająca imię, nazwisko i stanowisko</font>
                            </p>
                        </td>
                    </tr>
                </table>
            </font>
            <ea:PageBreak ID="PageBreak3" runat="server" Required="true"></ea:PageBreak>
            <ea:PageBreak ID="PageBreak5" runat="server" Required="true"></ea:PageBreak>

            <font face="Tahoma" size="2">
                <font face="Tahoma" size="4">
                    <b>INFORMACJA</b><br />
                </font>
                <font face="Tahoma" size="3">
                    <u><b>do zaświadczenia o zatrudnieniu i wynagrodzeniu</b></u><br />
                </font>
                <b>Informacje wstępne</b><br />
                <br />
                Wystawione przez Ciebie zaświadczenie o zatrudnieniu i wynagrodzeniu jest dokumentem, na podstawie którego
                ustalamy podstawę wymiaru renty z tytułu niezdolności do pracy oraz emerytury przyznawanej na starych zasadach,
                a także kapitału początkowego, jeśli wystawiłeś go za okres zatrudnienia przypadający przed 1999 r. O wysokości
                wymienionych świadczeń decyduje m.in. wysokość wynagrodzeń z poszczególnych lat wskazanych do ustalenia
                podstawy wymiaru świadczenia. Ważne jest zatem jej ustalenie na podstawie prawidłowo wystawionego przez
                Ciebie zaświadczenia.<br />
                <br />
                Zaświadczenie o zatrudnieniu i wynagrodzeniu może być również wystawione przez:<br />
                - następcę prawnego pracodawcy,<br />
                - likwidatora lub syndyka masy upadłości,<br />
                - podmiot upoważniony przez płatnika składek do wystawienia zaświadczenia,<br />
                - Krajowy Ośrodek Wsparcia Rolnictwa – dla pracowników zlikwidowanych przedsiębiorstw gospodarki rolnej.<br />
                <br />
                <b>WAŻNE!</b> Z uwagi na to, że na przestrzeni lat, przepisy regulujące zasady ustalania podstawy wymiaru składek na
                ubezpieczenia społeczne były wielokrotnie nowelizowane lub zmieniane, co znacząco rozszerzyło zakres składników
                wynagrodzenia i innych należności uwzględnianych w podstawie wymiaru świadczeń – w niniejszej Informacji
                wykazaliśmy tylko niektóre z nich i wynikające ze stosunku pracy<br />
                <br />
                <b>Wynagrodzenie i inne świadczenia przyjmowane do ustalenia podstawy wymiaru renty
                z tytułu niezdolności do pracy, emerytury przyznawanej na starych zasadach oraz
                kapitału początkowego</b><br />
                <br />
                Do ustalenia podstawy wymiaru renty z tytułu niezdolności do pracy oraz emerytury przyznawanej na starych zasadach
                przyjmuje się podstawę wymiaru składek na ubezpieczenia emerytalne i rentowe (począwszy od 1 stycznia 1999 r.)
                lub na ubezpieczenie społeczne (do 31 grudnia 1998 r.)
                <br />
                Do ustalenia podstawy wymiaru renty z ubezpieczenia wypadkowego przyjmuje się podstawę wymiaru składki na
                ubezpieczenie społeczne – do 31 grudnia 1998 r. oraz na ubezpieczenie wypadkowe – od 1 stycznia 1999 r. – bez
                ograniczenia do kwoty rocznej podstawy wymiaru składek na ubezpieczenia emerytalne i rentowe. 
                <br />
                Do ustalenia podstawy wymiaru kapitału początkowego przyjmuje się podstawę wymiaru składek na ubezpieczenie
                społeczne do 31 grudnia 1998 r.
                <br />
                Przy ustalaniu podstawy wymiaru wymienionych świadczeń przyjmuje się zatem kwoty stałych i zmiennych składników
                wynagrodzenia/ uposażenia (stałe wynagrodzenie zasadnicze, premie, nagrody, wartość świadczeń w naturze,
                dodatki do płac i inne należności), które stanowiły podstawę składki na ww. ubezpieczenia. 
                <br />
                Do ustalenia podstawy wymiaru świadczeń, przyjmuje się również:
                <ol>
                    <li>kwoty wynagrodzeń za czas niezdolności do pracy oraz zasiłków: chorobowego, macierzyńskiego, opiekuńczego,
                    przysługujących ubezpieczonemu w roku kalendarzowym przypadającym po 2004 r., z tym że:<br />
                        - jeśli łączna kwota przychodu za dany rok kalendarzowy przekroczy kwotę rocznej podstawy wymiaru składek
                    na ubezpieczenia emerytalne i rentowe albo jest równa tej kwocie – wówczas w podstawie wymiaru świadczenia
                    nie są uwzględniane kwoty ww. wynagrodzeń i zasiłków,<br />
                        - jeśli przychód za dany rok kalendarzowy jest niższy od kwoty rocznej podstawy wymiaru składek na ubezpieczenia
                    emerytalne i rentowe – wówczas kwoty ww. wynagrodzeń i zasiłków wlicza się do podstawy wymiaru świadczeń,
                    nie więcej jednak niż do osiągnięcia kwoty rocznej podstawy wymiaru składek na ubezpieczenia emerytalne
                    i rentowe,</li>
                    <li>kwoty świadczenia rehabilitacyjnego, zasiłku wyrównawczego, dodatku wyrównawczego i świadczenia wyrównawczego
                    (bez względu na to, czy zostały wypłacone za lata po 2004 r., czy też za lata wcześniejsze), a także 
                    kwoty wynagrodzeń za czas niezdolności do pracy oraz kwoty zasiłków: chorobowego, macierzyńskiego i opiekuńczego
                    przysługujących ubezpieczonemu za lata kalendarzowe przypadające przed 2005 r. – również wówczas,
                    gdy w danym roku kalendarzowym została osiągnięta kwota rocznej podstawy wymiaru składek na ubezpieczenia
                    emerytalne i rentowe,</li>
                    <li>kwoty składników wynagrodzenia (np. dodatku stażowego, dodatku ratowniczego, wynagrodzenia rocznego
                    z tytułu Karty Hutnika) wypłaconych obok wynagrodzenia za czas niezdolności do pracy, zasiłku chorobowego,
                    zasiłku macierzyńskiego, opiekuńczego, świadczenia rehabilitacyjnego, które wyłącznie w okresie pobierania
                    tego wynagrodzenia lub zasiłku nie stanowiły podstawy wymiaru składek na ubezpieczenia emerytalne i rentowe</li>
                </ol>
                W podstawie wymiaru świadczeń uwzględnia się także inne wypłacone ubezpieczonemu należności.<br />
                Przykładowo:<br />
                - wartość rekompensaty cenowej wypłaconej pracownikowi z tytułu podwyżki cen na artykuły żywnościowe, opał
                i energię obok wynagrodzenia lub zasiłku z ubezpieczenia społecznego, przy czym bez znaczenia pozostaje fakt,
                czy rekompensata była objęta składką na ubezpieczenie społeczne czy też nie.<br />
                Rekompensata wypłacana była w okresie od 1 września 1981 r. do 30 czerwca 1987 r.<br />
                Od wypłaconych rekompensat za okres do 30 kwietnia 1984 r. nie była opłacana składka na ubezpieczenie społeczne.
                Natomiast od 1 maja 1984 r. podstawę wymiaru składek na ubezpieczenie społeczne stanowiła połowa
                sumy wypłaconych pracownikowi rekompensat włączonych do wynagrodzenia zasadniczego.<br />
                Od 1 lipca 1987 r. rekompensaty włączono do wynagrodzenia zasadniczego i tym samym w całości podlegały
                obowiązkowi odprowadzenia składki na ubezpieczenie społeczne,<br />
                - wartość rekompensaty pieniężnej ustalonej z tytułu okresowego niepodwyższania płac w sferze budżetowej.<br />
                Za każdy miesiąc przepracowany w pełnym wymiarze czasu pracy, przyjmuje się:<br />
                &nbsp;&nbsp;&nbsp;— w okresie od 1 lipca 1991 r. do 31 grudnia 1991 r. kwotę – 46,00 zł, a<br />
                &nbsp;&nbsp;&nbsp;— w okresie od 1 stycznia 1992 r. do 28 czerwca 1992 r. kwotę – 58,00 zł.<br />
                W przypadku zatrudnienia w niepełnym wymiarze czasu pracy powyższe kwoty są proporcjonalnie zmniejszane.
                Należności z tytułu rekompensaty podlegają pomnożeniu przez 10 000, ponieważ dotyczą okresu przed denominacją
                złotego.<br />
                <br />
                <b>Ważna zasada</b><br />
                <br />
                Przy ustalaniu podstawy wymiaru świadczeń stosuje się zasadę, w myśl której w podstawie tej uwzględnia się
                wynagrodzenie i świadczenia za czas niezdolności do pracy przysługujące za okres, za który zostały wypłacone,
                czyli dolicza się je do roku, za który są należne. Zasadę tę stosuje się jedynie wówczas, gdy istnieje możliwość
                ustalenia okresu, za który dana wypłata przysługuje, jak to ma miejsce w przypadku, np. trzynastki, nagrody z zysku.
                Jeżeli nie jest możliwe ustalenie okresu, jakiego dana wypłata dotyczy albo z uwagi na jej specyfi kę – taką wypłatę
                dolicza się do miesiąca, w którym została wypłacona.<br />
                <br />
                <b>Wskazówki pomocne przy wypełnianiu zaświadczenia o zatrudnienu i wynagrodzeniu</b><br />
                <br />
                <b>Sekcja: <i>Informacje o pracowniku</i></b><br />
                <br />
                <b>Do pkt 1</b><br />
                Wpisz datę początku i końca zatrudnienia (dzień, miesiąc, rok). W przypadku gdy zatrudnienie trwa, wpisz tylko datę
                początkową.<br />
                <br />
                <b>Do pkt 2</b><br />
                Jeśli w zaświadczeniu potwierdziłeś okres zatrudnienia przypadający przed 15 listopada 1991 r., i w tym okresie
                pracownik był zatrudniony w niepełnym wymiarze, dodatkowo podaj wymiar czasu pracy oraz okres,
                w którym pracownik był zatrudniony w niepełnym wymiarze. Wymiar ten możesz wpisać w postaci ułamka zwykłego,
                np.:<br />
                - 1/2 – dla połowy wymiaru czasu pracy,<br />
                - 3/4 – dla trzech czwartych wymiaru czasu pracy,<br />
                - 7/8 – dla siedmiu ósmych wymiaru czasu pracy.<br />
                <br />
                <b>Tabela w sekcji: <i>Informacje o kwotach wynagrodzenia/ uposażenia, kwotach świadczeń wypłaconych
                w okresie niezdolności do pracy oraz kwotach innych należności – za dany rok kalendarzowy –
                uwzględnianych przy ustalaniu podstawy wymiaru emerytury, renty oraz kapitału początkowego</i></b><br />
                <br />
                <b>Do kolumny 2</b> tabeli <i>Kwoty stałych i zmiennych składników wynagrodzenia/ uposażenia – należnych za dany rok
                kalendarzowy, które stanowiły podstawę wymiaru składek na ubezpieczenie społeczne/ ubezpieczenia emerytalne
                i rentowe</i><br />
                <br />
                <b>W kolumnie 2</b> wpisz kwoty wszystkich tych składników wynagrodzenia/ uposażenia, które w okresie zatrudnienia
                były objęte składką na ubezpieczenie społeczne lub ubezpieczenia emerytalne i rentowe. Wszystkie wypłaty dolicz do
                roku, za który są należne. Jeżeli, np. nagrodę z zysku lub trzynastkę należną za 2001 r. wypłaciłeś w 2002 r. – kwotę
                tej nagrody i trzynastki dolicz do roku 2001 r., czyli do roku za który przysługuje. Oznacza to również konieczność
                wyłączenia kwoty nagrody i trzynastki z roku, w którym została wypłacona, czyli z 2002 r.<br />
                <br />
                Taką samą zasadę stosujesz, jeżeli wpłata, np. trzynastki lub nagrody z zysku dotyczy roku, w którym przekroczona
                została roczna podstawa wymiaru składki na ubezpieczenia emerytalne i rentowe. Wypłaty te dolicz do roku, za który
                są należne – o ile w roku wypłaty stanowiły podstawę wymiaru składki.<br />
                <br />
                W przypadku wypłaty w danym roku, co do której nie jest możliwe ustalenie roku, za który wypłata ta przysługuje, dolicz
                ją do danego roku, czyli do roku wypłaty.<br />
                <br />
                Przy zachowaniu powyższej zasady w kolumnie 2 podaj kwoty:<br />
                - wynagrodzenia zasadniczego i innych stałych składników, np. dodatku: stażowego, funkcyjnego, zmianowego, za
                pracę w warunkach szkodliwych dla zdrowia,<br />
                - wynagrodzenia obejmującego świadczenia w naturze (w kwotach stanowiących podstawę wymiaru składek na
                ubezpieczenie społeczne lub ubezpieczenia emerytalno-rentowe),<br />
                - zmiennych składników wynagrodzenia, np. premii regulaminowych, nagrody uznaniowej,<br />
                - innych wynagrodzeń, składników wynagrodzenia za pracę.<br />
                <br />
                <b>Do kolumny 3</b> tabeli <i>Kwoty świadczeń należnych za dany rok kalendarzowy (wynagrodzenia za czas niezdolności
                do pracy, zasiłków: chorobowego, opiekuńczego, macierzyńskiego)</i><br />
                <br />
                <b>W kolumnie 3</b> wpisz należne za dany rok kalendarzowy kwoty:<br />
                - wynagrodzenia za czas niezdolności do pracy, przysługującego na podstawie art. 92 Kodeksu pracy lub przysługującego
                na podstawie ustaw szczególnych (np. na podstawie ustawy Karta Nauczyciela), wypłaconego po 28 lutego 1995 r.,<br />
                - zasiłków chorobowych,<br />
                - zasiłku macierzyńskiego,<br />
                - zasiłku opiekuńczego.<br />
                <br />
                <b>Do kolumny 4</b> tabeli <i>Kwoty świadczeń należnych za dany rok kalendarzowy (świadczenia rehabilitacyjnego zasiłku/
                świadczenia/ dodatku – wyrównawczego)</i><br />
                <br />
                <b>W kolumnie 4</b> wpisz należne za dany rok kalendarzowy kwoty:<br />
                - świadczenia rehabilitacyjnego,<br />
                - dodatku wyrównawczego, świadczenia wyrównawczego i zasiłku wyrównawczego.<br />
                <br />
                <b>Do kolumny 5</b> tabeli <i>Kwoty składników wynagrodzenia za dany rok kalendarzowy, wypłaconych obok wynagrodzenia
                za czas niezdolności do pracy, zasiłku chorobowego, macierzyńskiego, opiekuńczego, świadczenia rehabilitacyjnego,
                które w okresie pobierania tego wynagrodzenia lub zasiłku nie stanowiły podstawy wymiaru składek na ubezpieczenie
                społeczne/ ubezpieczenia emerytalne i rentowe</i><br />
                <br />
                <b>W kolumnie 5</b> przy danym roku kalendarzowym wpisz: należne za ten rok kwoty:<br />
                - składników wynagrodzenia (np. dodatku stażowego, dodatku ratowniczego), które w okresie świadczenia pracy
                stanowią podstawę wymiaru składek na ubezpieczenia emerytalne i rentowe, a wyłączenie ich z tej podstawy
                nastąpiło tylko dlatego, że zostały wypłacone obok świadczeń związanych z niezdolnością do pracy lub macierzyństwem.
                Prawo do pobierania ww. składników wynagrodzenia w czasie niezdolności do pracy, wynika z postanowień układów
                zbiorowych pracy lub przepisów o wynagrodzeniu stosowanych w danym zakładzie pracy.<br />
                <br />
                Prawo do pobierania ww. składników wynagrodzenia w czasie niezdolności do pracy, wynika z postanowień układów
                zbiorowych pracy lub przepisów o wynagrodzeniu stosowanych w danym zakładzie pracy<br />
                <br />
                <b>Do kolumny 6</b> tabeli <i>Kwoty przychodu należnego za dany rok kalendarzowy, który nie stanowił podstawy wymiaru
                składek na ubezpieczenia emerytalne i rentowe, a stanowił podstawę wymiaru składek na ubezpieczenie wypadkowe</i><br />
                <br />
                <b>W kolumnie 6</b> wpisz kwoty przychodu, należnego za dany rok kalendarzowy objętego składką na ubezpieczenie
                wypadkowe. Wszystkie wypłaty dolicz do roku, za który są należne. Jeżeli, np. nagrodę z zysku lub trzynastkę należną za
                2008 r. wypłaciłeś w 2009 r. – kwotę tej nagrody i trzynastki dolicz do 2008 r., czyli do roku za który przysługuje. Oznacza
                to również konieczność wyłączenia kwoty nagrody i trzynastki z roku, w którym została wypłacona, czyli z 2009 r.<br />
                <br />
                W przypadku wypłaty w danym roku, co do której nie jest możliwe ustalenie okresu roku, za który wypłata ta
                przysługuje, dolicz ją do danego roku, czyli do roku wypłaty.<br />
                <br />
                Przy zachowaniu powyższej zasady w kolumnie 5 wpisz kwoty:<br />
                - przychodu (wynagrodzenia zasadniczego i innych stałych składników, np. dodatku: stażowego, funkcyjnego,
                zmianowego, za pracę w warunkach szkodliwych dla zdrowia),<br />
                - wynagrodzenia obejmującego świadczenia w naturze,<br />
                - zmiennych składników wynagrodzenia, np. premii regulaminowych, nagrody uznaniowej,<br />
                - innych wynagrodzeń, składników wynagrodzenia za pracę.<br />
                <br />
                <b>Do kolumny 7</b> tabeli <i>Kwoty innych wypłaconych należności, które nie zostały wykazane w kolumnach 2–6 i ich
                rodzaj – o ile są one wliczane do podstawy wymiaru świadczeń</i><br />
                <br />
                <b>W kolumnie 7</b> przy danym roku kalendarzowym wpisz kwoty innych wypłat, których nie wykazałeś w kolumnach 2–6
                oraz rodzaj tej wypłaty, np.:br />
                - kwotę rekompensaty wypłaconej pracownikowi z tytułu podwyżki cen na artykuły żywnościowe, opał i energię, która
                była wypłacana obok wynagrodzenia lub zasiłku z ubezpieczenia społecznego w okresie od 1 września 1981 r.
                do 30 czerwca 1987 r.,<br />
                - kwotę rekompensaty pieniężnej ustalonej z tytułu okresowego niepodwyższania płac w sferze budżetowej.<br />
                <br />
                <b>Sekcja: <i>Informacja o przekroczeniu rocznej podstawy wymiaru składek na ubezpieczenia
                emerytalne i rentowe</i></b><br />
                <br />
                Jeśli pracownik przekroczył roczną podstawę wymiaru składek na ubezpieczenia emerytalne i rentowe wpisz rok
                i miesiąc, w którym to przekroczenie nastąpiło.<br />
                <br />
                <b>Sekcja: <i>Informacje dotyczące pełnomocnika upoważnionego przez płatnika składek do
                wystawienia zaświadczenia</i></b><br />
                <br />
                Jeżeli wystawiasz zaświadczenie w imieniu pracodawcy, który udzielił Ci pełnomocnictwa wpisz swoje dane:<br />
                - nazwę i adres fi rmy,<br />
                - NIP albo REGON,<br />
                - PESEL – jeśli nie masz nadanego NIP i REGON,<br />
                - zakres udzielonego pełnomocnictwa i termin jego obowiązywania.<br />
                <br />
                <b>Przykłady pomoce przy wypełnianiu tabeli na str. 3 zaświadczenia o zatrudnienu
                i wynagrodzeniu</b><br />
                <br />
                <b>Przykład 1</b><br />
                W tym przykładzie pokażemy Ci, jak prawidłowo wypełnić tabelę, w sytuacji gdy ubezpieczonemu w okresie zatrudnienia
                od 6 maja 1999 r. do 31 października 2006 r. wynagrodzenie należne za grudzień wypłacono w styczniu następnego roku.
                Ubezpieczonemu również w marcu 2004 r., 2005 r. i 2006 r. wypłacono nagrodę z zysku za lata poprzednie.<br />
                <br />
                Ubezpieczonemu w:<br />
                - 1999 r. wypłacono wynagrodzenie w łącznej kwocie 20 000,00 zł,<br />
                - 2000 r. wypłacono wynagrodzenie w łącznej kwocie 40 000,00 zł, w tym w styczniu 2000 r. wypłacono wynagrodzenie
                za grudzień 1999 r. w kwocie 3000,00 zł,<br />
                - 2001 r. wypłacono wynagrodzenie w łącznej kwocie 42 000,00 zł, w tym w styczniu 2001 r. wypłacono wynagrodzenie
                za grudzień 2000 r. w kwocie 3300,00 zł,<br />
                - 2002 r. wypłacono wynagrodzenie w łącznej kwocie 46 000,00 zł, w tym w styczniu 2002 r. wypłacono wynagrodzenie
                za grudzień 2001 r. w kwocie 3500,00 zł,<br />
                - 2003 r. wypłacono wynagrodzenie w łącznej kwocie 48 000,00 zł, w tym w styczniu 2003 r. wypłacono wynagrodzenie
                za grudzień 2002 r. w kwocie 3700,00 zł,<br />
                - 2004 r. wypłacono wynagrodzenie w łącznej kwocie 52 000,00 zł, w tym w styczniu 2004 r. wypłacono wynagrodzenie
                za grudzień 2003 r. w kwocie 3900,00 zł oraz w marcu 2004 r. wypłacono nagrodę z zysku za 2003 r.
                w kwocie 4000,00 zł,<br />
                - 2005 r. wypłacono wynagrodzenie w łącznej kwocie 60 000,00 zł, w tym w styczniu 2005 r. wypłacono wynagrodzenie
                za grudzień 2004 r. w kwocie 4800,00 zł, oraz w marcu 2005 r. wypłacono nagrodę z zysku za 2004 r.
                w kwocie 4600,00 zł,<br />
                - 2006 r. wypłacono wynagrodzenie w łącznej kwocie 69 000,00 zł, w tym w styczniu 2006 r. wypłacono wynagrodzenie
                za grudzień 2005 r. w kwocie 6000,00 zł oraz w marcu 2006 r. wypłacono nagrodę z zysku za 2005 r.
                w kwocie 5200,00 zł.<br />
                <br />
                Przychód, który należy wykazać w kolumnie 2 tabeli za:<br />
                - 1999 r. wynosi <b>23 000,00 zł</b> (20 000,00 zł + 3000,00 zł),<br />
                - 2000 r. wynosi <b>40 300,00 zł</b> (40 000,00 zł – 3000,00 zł + 3300,00 zł),<br />
                - 2001 r. wynosi <b>42 200,00 zł</b> (42 000,00 zł – 3300,00 zł + 3500,00 zł),<br />
                - 2002 r. wynosi <b>46 200,00 zł</b> (46 000,00 zł – 3500,00 zł + 3700,00 zł),<br />
                - 2003 r. wynosi <b>52 200,00 zł</b> (48 000,00 zł – 3700,00 zł + 3900,00 zł + 4000,00 zł),<br />
                - 2004 r. wynosi <b>53 500,00 zł</b> (52 000,00 zł – 3900,00 zł – 4000,00 zł + 4800,00 zł + 4600,00 zł),<br />
                - 2005 r. wynosi <b>61 800,00 zł</b> (60 000,00 zł – 4800,00 zł – 4600,00 zł + 6000,00 zł + 5200,00 zł),<br />
                - 2006 r. wynosi <b>57 800,00 zł</b> (69 000,00 zł – 6000,00 zł – 5200,00 zł).<br />
                Ubezpieczonemu w okresie zatrudnienia wypłacono również wynagrodzenie za czas niezdolności do pracy z powodu
                choroby:<br />
                - w 2002 r. w kwocie <b>950,00 zł</b>,<br />
                - w 2006 r. w kwocie <b>1100,00 zł</b>.<br />
                <br />
                <b>Przykład 2</b><br />
                W kolejnym przykładzie pokażemy Ci, jak prawidłowo wypełnić tabelę, w sytuacji gdy ubezpieczonemu w okresie
                zatrudnienia od 2 lutego 2002 r. do 31 sierpnia 2008 r. wypłacono trzynastkę należną za rok poprzedni i u którego
                w latach 2004–2006 nastąpiło przekroczenie kwoty rocznego ograniczenia podstawy wymiaru składek na ubezpieczenia
                emerytalne i rentowe. Kwota ta wynosiła w:<br />
                - 2004 r. – 68 700,00 zł,<br />
                - 2005 r. – 72 690,00 zł,<br />
                - 2006 r. – 73 560,00 zł.<br />
                <br />
                Ubezpieczonemu w:<br />
                - 2002 r. wypłacono wynagrodzenie w łącznej kwocie 58 000,00 zł,<br />
                - 2003 r. wypłacono wynagrodzenie w łącznej kwocie 62 000,00 zł, w tym w marcu 2003 r. wypłacono trzynastkę za
                2002 r. w kwocie 4800,00 zł,<br />
                - 2004 r. wypłacono wynagrodzenie w łącznej kwocie 68 700,00 zł, w tym w marcu 2004 r. wypłacono trzynastkę za
                2003 r. w kwocie 6000,00 zł. (ubezpieczony kwotę rocznego ograniczenia podstawy wymiaru przekroczył w listopadzie).
                W listopadzie i w grudniu 2004 r. ubezpieczonemu wypłacono wynagrodzenie w kwocie <b>7000,00 zł</b>, od
                którego odprowadzona została składka na ubezpieczenie wypadkowe i chorobowe,<br />
                - 2005 r. wypłacono wynagrodzenie w łącznej kwocie 72 690,00 zł, w tym w marcu 2005 r. wypłacono trzynastkę
                za 2004 r. w kwocie 7000,00 zł. (ubezpieczony kwotę rocznego ograniczenia podstawy wymiaru przekroczył
                w listopadzie). W listopadzie i w grudniu 2005 r. ubezpieczonemu wypłacono wynagrodzenie w łącznej kwocie
                <b>7200,00 zł</b>, od którego odprowadzona została składka na ubezpieczenie wypadkowe i chorobowe,<br />
                - 2006 r. wypłacono wynagrodzenie w łącznej kwocie 73 560,00 zł, w tym w marcu 2006 r. wypłacono trzynastkę
                za 2005 r. w kwocie 7700,00 zł, (ubezpieczony kwotę rocznego ograniczenia podstawy wymiaru przekroczył
                w listopadzie). W listopadzie i w grudniu 2006 r. ubezpieczonemu wypłacono wynagrodzenie w łącznej kwocie
                <b>7500,00 zł</b>, od którego odprowadzona została składka na ubezpieczenie wypadkowe i chorobowe,<br />
                - 2007 r. wypłacono wynagrodzenie w łącznej kwocie 77 800,00 zł, w tym w marcu 2007 r. wypłacono trzynastkę za
                2006 r. w kwocie 8000,00 zł,<br />
                - 2008 r. wypłacono wynagrodzenie w łącznej kwocie 65 000,00 zł, w tym w marcu 2008 r. wypłacono trzynastkę za
                2007 r. w kwocie 8200,00 zł.<br />
                <br />
                Przychód, który należy wykazać w kolumnie 2 tabeli, za:<br />
                - 2002 r. wynosi <b>62 800,00 zł</b> (58 000,00 zł + 4800,00 zł),<br />
                - 2003 r. wynosi <b>63 200,00 zł</b> (62 000,00 zł – 4800,00 zł + 6000,00 zł),<br />
                - 2004 r. wynosi <b>69 700,00 zł</b> (68 700,00 zł – 6000,00 zł + 7000,00 zł),<br />
                - 2005 r. wynosi <b>73 390,00 zł</b> (72 690,00 zł – 7000,00 zł + 7700,00 zł),<br />
                - 2006 r. wynosi <b>73 860,00 zł</b> (73 560,00 zł – 7700,00 zł + 8000,00 zł),<br />
                - 2007 r. wynosi <b>78 000,00 zł</b> (77 800,00 zł – 8000,00 zł + 8200,00 zł),<br />
                - 2008 r. wynosi <b>56 800,00 zł</b> (65 000,00 zł – 8200,00 zł).<br />
                <br />
                Ubezpieczonemu w okresie zatrudnienia wypłacono również wynagrodzenie za czas niezdolności do pracy z powodu
                choroby i zasiłki chorobowe:<br />
                - w 2003 r. w łącznej kwocie <b>1050,50 zł</b>,<br />
                - w 2006 r. w łącznej kwocie <b>1000,00 zł</b>.<br />
                <br />
                <b>Podstawa prawna</b><br />
                - Ustawa z dnia 17 grudnia 1998 r. o emeryturach i rentach z Funduszu Ubezpieczeń Społecznych (Dz.U. z 2017 r.
                poz. 1383, z późn. zm.),<br />
                - Ustawa z dnia 30 października 2002 r. o ubezpieczeniu społecznym z tytułu wypadków przy pracy i chorób zawodowych
                (Dz.U. z 2017 r. poz. 1773, z późn. zm.),<br />
                - Rozporządzenie Rady Ministrów z dnia 1 kwietnia 1985 r. w sprawie szczegółowych zasad ustalania podstawy
                wymiaru emerytur i rent (Dz.U. z 1989 r. Nr 11, poz. 63, z późn. zm.) – w zakresie, w którym przepisy tego rozporządzenia
                nie są sprzeczne z przepisami ustawy o emeryturach i rentach z FUS,<br />
                - Rozporządzenie Ministra Pracy i Polityki Socjalnej z dnia 18 grudnia 1998 r. w sprawie szczegółowych zasad ustalania
                podstawy wymiaru składek na ubezpieczenia emerytalne i rentowe (Dz.U. z 2017 r. poz. 1949).<br />
            </font>
        </ea:Section>
        <p><span style="font-size: 10pt"><strong>ZUS ERP-7</strong></span></p>
        <ea:SectionMarker ID="SectionMarker8" runat="server" SectionType="GlobalFooter"></ea:SectionMarker>
        <ea:PageBreak id="PageBreak6" runat="server" Required="true"></ea:PageBreak>
        <cc1:reportheader id="ReportHeader2"
            title="ZAŁĄCZNIK DO ZAŚWIADCZENIA O ZATRUDNIENIU I WYNAGRODZENIU|Zestawienie wynagrodzeń/zasiłków pobranych za okresy niezdolności do pracy.|&lt;/strong&gt;%PŁEĆ%: &lt;strong&gt; {0}"
            runat="server" DataMember0="Pracownik.ImięNazwisko">
        </cc1:reportheader>
        <p>
            <ea:Grid id="Grid2" runat="server" GroupData0="Kategoria" GroupLine="{0}">
                <columns>
					<ea:GridColumn ID="GridColumn8" Caption="Nieobecność" runat="server" DataMember="Nazwa"></ea:GridColumn>
					<ea:GridColumn ID="GridColumn9" runat="server" Caption="Od dnia" DataMember="Okres.From" 
                        Align="Center" Width="20">
                    </ea:GridColumn>
                    <ea:GridColumn ID="GridColumn10" runat="server" Caption="Do dnia" DataMember="Okres.To" 
                        Align="Center" Width="20">
                    </ea:GridColumn>
				</columns>
            </ea:Grid>
        </p>
        <p><span style="font-size: 10pt"><strong>ZUS ERP-7</strong></span></p>
        <cc1:ReportFooter id="ReportFooter1" runat="server" TheEnd="False"></cc1:ReportFooter>
    </form>
</body>
</html>
